package cn.com.duiba.boot.ext.autoconfigure.data.elasticsearch;

import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.client.Client;
import org.springframework.data.elasticsearch.core.DefaultResultMapper;
import org.springframework.data.elasticsearch.core.GetResultMapper;
import org.springframework.data.elasticsearch.core.ResultsMapper;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.query.GetQuery;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2017年05月02日 10:49
 * @descript:
 * @version: 1.0
 */
public class ElasticsearchTemplate extends org.springframework.data.elasticsearch.core.ElasticsearchTemplate {

    private Client client;
    private ElasticsearchConverter elasticsearchConverter;
    private ResultsMapper resultsMapper;
    private String searchTimeout;

    public ElasticsearchTemplate(Client client, ElasticsearchConverter elasticsearchConverter, String searchTimeout) {
        super(client,elasticsearchConverter);
        this.client = client;
        this.elasticsearchConverter = elasticsearchConverter;
        this.resultsMapper = new DefaultResultMapper(elasticsearchConverter.getMappingContext());
        this.searchTimeout = searchTimeout;
    }

    @Override
    public <T> T queryForObject(GetQuery query, Class<T> clazz, GetResultMapper mapper) {

        if(searchTimeout == null){
            return super.queryForObject(query,clazz,mapper);
        }

        ElasticsearchPersistentEntity<T> persistentEntity = getPersistentEntityFor(clazz);
        GetResponse response = client.prepareGet(persistentEntity.getIndexName(), persistentEntity.getIndexType(), query.getId()).execute()
                .actionGet(searchTimeout);

        T entity = mapper.mapResult(response, clazz);
        return entity;
    }
}

