package cn.com.duiba.boot.ext.autoconfigure.web.mvc;

import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

import java.util.List;

/**
 * 给 RequestMappingHandlerAdapter 增加自定义的参数解析器.
 * 这个解析器会在参数所属类的接口注解了@AdvancedFeignClient时生效，把所有的参数按照json格式来反序列化到参数上。
 */
@Configuration
@ConditionalOnWebApplication
public class CustomWebMvcConfiguration extends WebMvcConfigurerAdapter implements Ordered {

    @Override
    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.add(new AdvancedFeignClientArgumentResolver());
    }

    @Override
    public int getOrder() {
        return 0;
    }
}
