package cn.com.duiba.boot.ext.autoconfigure.web.mvc;

import org.springframework.boot.autoconfigure.web.WebMvcRegistrationsAdapter;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

/**
 * 使用自定义的CustomRequestMappingHandlerMapping，它的主要作用是方便重用FeignClient。
 * 目前官方spring mvc支持在父类方法中定义RequestMapping，子类可以不定义RequestMapping，然而如果此时父类参数加了RequestParam等注解，是不会生效的，必须写在子类中。这样的话父类和子类都必须写，非常繁琐。
 * 这个CustomRequestMappingHandlerMapping的作用就是让spring到声明RequestMapping的方法上去找参数注解
 * <br/>
 * 功能2：如果一个Controller的接口注解了AdvancedFeignClient，则对于这个接口进行自动扫描，对所有接口上的方法，无论有没有RequestMapping都作为一个mvc方法来处理并注册,path为方法名
 *
 * Created by wenqi.huang on 2017/7/17.
 */
@Configuration
public class CustomWebMvcRegistrations extends WebMvcRegistrationsAdapter {

    @Override
    public RequestMappingHandlerMapping getRequestMappingHandlerMapping() {
        return new CustomRequestMappingHandlerMapping();
    }

}
