/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.cloud.netflix.hystrix;

import cn.com.duiba.boot.ext.autoconfigure.cloud.netflix.hystrix.CustomHystrixConcurrencyStrategy;
import com.netflix.hystrix.Hystrix;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import java.util.Set;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.embedded.EmbeddedWebApplicationContext;
import org.springframework.cloud.netflix.feign.CustomFeignClientsRegistrar;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;

@Configuration
@ConditionalOnClass(value={Hystrix.class})
public class HystrixAutoConfiguration {
    @Bean
    public HystrixConcurrencyStrategy getHystrixConcurrencyStrategy() {
        return new CustomHystrixConcurrencyStrategy();
    }

    @Bean
    public ApplicationListener HystrixInitListener() {
        return new ApplicationListener<ContextRefreshedEvent>(){

            public void onApplicationEvent(ContextRefreshedEvent event) {
                Set<String> enabledFeignClientNames;
                if (event.getApplicationContext() instanceof EmbeddedWebApplicationContext && !(enabledFeignClientNames = CustomFeignClientsRegistrar.getEnabledFeignClientNames()).isEmpty()) {
                    String anyfeignClientName = enabledFeignClientNames.iterator().next();
                    HystrixCommand<String> command = new HystrixCommand<String>(HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)anyfeignClientName)).andCommandKey(HystrixCommandKey.Factory.asKey((String)"bootInit"))){

                        protected String run() throws Exception {
                            return null;
                        }
                    };
                    command.execute();
                }
            }
        };
    }
}

