/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.core.ttl;

import cn.com.duiba.boot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import cn.com.duiba.boot.ext.autoconfigure.threadpool.wrapper.ScheduledThreadPoolExecutorWrapper;
import cn.com.duiba.boot.ext.autoconfigure.threadpool.wrapper.ThreadPoolExecutorWrapper;
import com.alibaba.ttl.threadpool.TtlExecutors;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;

public class TransmittableExecutorBeanPostProcessor
implements SpecifiedBeanPostProcessor<Executor> {
    private static Logger logger = LoggerFactory.getLogger(TransmittableExecutorBeanPostProcessor.class);

    @Override
    public Class<Executor> getBeanType() {
        return Executor.class;
    }

    @Override
    public Object postProcessBeforeInitialization(Executor bean, String beanName) throws BeansException {
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(Executor bean, String beanName) throws BeansException {
        if (bean instanceof ScheduledThreadPoolExecutorWrapper || bean instanceof ThreadPoolExecutorWrapper) {
            return bean;
        }
        if (bean instanceof ScheduledExecutorService) {
            bean = TtlExecutors.getTtlScheduledExecutorService((ScheduledExecutorService)((ScheduledExecutorService)bean));
        } else if (bean instanceof ExecutorService) {
            bean = TtlExecutors.getTtlExecutorService((ExecutorService)((ExecutorService)bean));
        } else if (bean instanceof Executor) {
            bean = TtlExecutors.getTtlExecutor((Executor)bean);
        }
        return bean;
    }

    public int getOrder() {
        return 0;
    }
}

