package cn.com.duibaboot.ext.autoconfigure.graceclose;

import java.io.PrintStream;

import cn.com.duibaboot.ext.autoconfigure.DuibaBootVersion;
import org.springframework.boot.SpringBootVersion;
import org.springframework.boot.ansi.AnsiColor;
import org.springframework.boot.ansi.AnsiOutput;
import org.springframework.boot.ansi.AnsiStyle;

/**
 * Default Banner implementation which writes the 'Spring' banner.
 *
 * @author Phillip Webb
 */
class DuibaBootBanner {

//	private static final String[] BANNER1 = {
//				"          _               _",
//				"  .      | |          _  | |             __ _ _",
//				" /\\\\   __| | __   _  (_) | |,__    _  _  \\ \\ \\ \\",
//				"( ( ) / _` | | ' | | | | |  _  \\  / _` |  \\ \\ \\ \\",
//				" \\\\/ | (_| | | |_| | | | | |_) | | (_| |   ) ) ) )",
//				"  '   \\__,_| \\_____| |_| ._____/  \\_,\\ \\  / / / /",
//				" ========================================/_/_/_/"
//	};

	private static final String BANNER =
			"          _         _\n" +
			"  .      | |      _| |           __ _ _\n" +
			" /\\\\   __| |_   _(_) |,__  _  _  \\ \\ \\ \\\n" +
			"( ( ) / _` | ' | | |  _  \\/ _` |  \\ \\ \\ \\\n" +
			" \\\\/ ( (_| | |_| | | |_) | (_| |   ) ) ) )\n" +
			"  '   \\__,_|\\____|_|.____/\\_,|_\\  / / / /\n" +
			" ================================/_/_/_/";

	private static final String DUIBA_BOOT = " :: Duiba Boot :: ";
	private static final String SPRING_BOOT = " :: Spring Boot :: ";

	private static final int STRAP_LINE_SIZE = 42;

	public void printBanner(PrintStream printStream) {
		printStream.println(BANNER);

		String version = DuibaBootVersion.getVersion();
		version = (version == null ? "" : " (v" + version + ")");
		String padding = "";
		while (padding.length() < STRAP_LINE_SIZE
				- (version.length() + DUIBA_BOOT.length())) {
			padding += " ";
		}

		printStream.println(AnsiOutput.toString(AnsiColor.GREEN, DUIBA_BOOT,
				AnsiColor.DEFAULT, padding, AnsiStyle.FAINT, version));

		version = SpringBootVersion.getVersion();
		version = (version == null ? "" : " (v" + version + ")");
		padding = "";
		while (padding.length() < STRAP_LINE_SIZE
				- (version.length() + SPRING_BOOT.length())) {
			padding += " ";
		}

		printStream.println(AnsiOutput.toString(AnsiColor.GREEN, SPRING_BOOT,
				AnsiColor.DEFAULT, padding, AnsiStyle.FAINT, version));
		printStream.println();
	}

//	public static void main(String[] args) {
//		new DuibaBootBanner().printBanner(System.out);
//	}

}
