/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.core;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationNotAllowedException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.SimpleApplicationEventMulticaster;

@Configuration
@ConditionalOnProperty(name={"spring.event.use-executor"}, havingValue="true", matchIfMissing=true)
public class ApplicationEventMulticasterAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationEventMulticasterAutoConfiguration.class);

    @Bean(name={"applicationEventMulticaster"})
    public SimpleApplicationEventMulticaster simpleApplicationEventMulticaster() {
        SimpleApplicationEventMulticaster multicaster = new SimpleApplicationEventMulticaster();
        multicaster.setErrorHandler(t -> {
            if (t instanceof BeanCreationNotAllowedException && "eurekaAutoServiceRegistration".equals(((BeanCreationNotAllowedException)t).getBeanName()) && t.getMessage() != null && t.getMessage().contains("Singleton bean creation not allowed while singletons of this factory are in destruction")) {
                return;
            }
            logger.warn("Error calling ApplicationEventListener", t);
        });
        return multicaster;
    }
}

