/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.httpclient;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={HttpClient.class})
@AutoConfigureBefore(name={"org.springframework.cloud.netflix.feign.ribbon.FeignRibbonClientAutoConfiguration"})
public class HttpClientAutoConfiguration {
    @Bean(name={"httpClient"}, destroyMethod="close")
    public CloseableHttpClient httpClient() {
        return HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(60000).setConnectionRequestTimeout(10).build()).setMaxConnPerRoute(100).setUserAgent("Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.115 Safari/537.36").disableAutomaticRetries().disableCookieManagement().useSystemProperties().setKeepAliveStrategy((ConnectionKeepAliveStrategy)new DefaultConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                long time = super.getKeepAliveDuration(response, context);
                if (time == -1L) {
                    time = 30000L;
                }
                return time;
            }
        }).build();
    }

    public static void main(String[] args) {
        final CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(60000).setConnectionRequestTimeout(10).build()).setMaxConnPerRoute(1).setMaxConnTotal(200).setUserAgent("Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.115 Safari/537.36").disableAutomaticRetries().disableCookieManagement().useSystemProperties().setKeepAliveStrategy((ConnectionKeepAliveStrategy)new DefaultConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                long time = super.getKeepAliveDuration(response, context);
                if (time == -1L) {
                    time = 30000L;
                }
                return time;
            }
        }).setConnectionTimeToLive(30L, TimeUnit.SECONDS).build();
        ExecutorService es = Executors.newFixedThreadPool(100);
        for (int i = 0; i < 1; ++i) {
            es.execute(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        HttpGet req = new HttpGet("http://www.duiba.com.cn");
                        try {
                            CloseableHttpResponse r = httpClient.execute((HttpUriRequest)req);
                            System.out.println("-----------:" + r.getStatusLine().getStatusCode());
                            IOUtils.toByteArray((InputStream)r.getEntity().getContent());
                            r.getEntity().getContent().close();
                            continue;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            });
        }
    }
}

