package cn.com.duibaboot.ext.autoconfigure.cloud.config;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * 添加一些配置以禁止某些无用特性,比如servo等.
 */
public class DuibaEnvironmentPostProcessor implements EnvironmentPostProcessor {
    private static final Map<String, Object> properties;
    static {
        Map<String, Object> overrideProperties = new HashMap<String, Object>();
        //配置禁用netflix servo监控
        overrideProperties.put("spring.metrics.servo.enabled", "false");
        overrideProperties.put("spring.metrics.export.enabled", "false");

        properties = Collections.unmodifiableMap(overrideProperties);
    }

    @Override
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        PropertySource<?> propertySource = new MapPropertySource("duibaBootDefaultConfig",
                properties);
        environment.getPropertySources().addLast(propertySource);
    }
}
