package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.hystrix;

import cn.com.duibaboot.ext.autoconfigure.core.rpc.RpcContext;
import com.alibaba.ttl.TtlCallable;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;

import java.util.concurrent.Callable;

/**
 * hyxtrix插件，使用spi机制生效
 * 使用TtlCallable封装，以支持TransmittableThreadLocal，让hystrix中运行的线程得到上级线程设置的线程本地变量
 */
public class CustomHystrixConcurrencyStrategy extends HystrixConcurrencyStrategy {

    /**
     * 使用TtlCallable封装，以支持TransmittableThreadLocal
     * @param callable
     * @param <T>
     * @return
     */
    @Override
    public <T> Callable<T> wrapCallable(Callable<T> callable) {
        return new CallableWrapper(TtlCallable.get(callable));
    }

    private static class CallableWrapper implements Callable{

        private Callable callable;

        public CallableWrapper(Callable callable){
            this.callable = callable;
        }

        //得到当前线程的context的副本
        private RpcContext rpcContext = RpcContext.getContext().clone();

        @Override
        public Object call() throws Exception {
            //把父线程的context设置到当前线程中
            RpcContext.setContext(rpcContext);
            try {
                return callable.call();
            }finally{
                RpcContext.removeContext();
            }
        }
    }
}
