/*
 * Copyright 2012-2015 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.com.duibaboot.ext.autoconfigure.web;

import cn.com.duibaboot.ext.autoconfigure.core.DuibaServerProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;

import javax.annotation.Resource;
import javax.servlet.DispatcherType;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

/**
 * 自动配置Tomcat、Jetty、Undertow等容器，增加http线程池监控，如果在队列中等待超过1秒，则打印error日志提示线程池过小
 * <br/>
 * 如果是内部服务，使用固定大小的线程池,并拒绝在http线程池工作队列中等待过久的任务，让客户端可以尽快重试
 */
@Configuration
@ConditionalOnWebApplication
@EnableConfigurationProperties({DuibaServerProperties.class})
public class DuibaEmbeddedServletContainerAutoConfiguration {

//	/**
//	 * Nested configuration for if Tomcat is being used.
//	 */
//	@Configuration
//	@ConditionalOnClass({ Servlet.class, Tomcat.class })
//	@ConditionalOnMissingBean(value = EmbeddedServletContainerFactory.class, search = SearchStrategy.CURRENT)
//	public static class EmbeddedTomcat {
//
//		@Bean
//		public TomcatEmbeddedServletContainerFactory tomcatEmbeddedServletContainerFactory() {
//			return new TomcatEmbeddedServletContainerFactory();
//		}
//
//	}

	@Resource
	private DuibaServerProperties duibaServerProperties;

	/**
	 * 自动配置Tomcat、Jetty等容器，增加http线程池监控，如果在队列中等待超过1秒，则打印error日志提示线程池过小<br/>
	 * 如果是内部服务，使用固定大小的线程池,并拒绝在http线程池工作队列中等待过久的任务，让客户端可以尽快重试
	 * @return
	 */
	@Bean
	public ThreadPoolServletContainerCustomizer getThreadPoolServletContainerCustomizer(){
		return new ThreadPoolServletContainerCustomizer(duibaServerProperties);
	}

	/**
	 * FailFastFilter，判断当前http线程在 httpFailFastExecutor（线程名前缀为HttpFailFastThread）中执行时，直接抛出RejectedExecutionException
	 * ，以让HTTP Rest RPC客户端尽快到其他客户端安全地重试。
	 * @return
	 */
	@Bean
	public FilterRegistrationBean getFailFastFilter(){
		FailFastFilter filter=new FailFastFilter();
		FilterRegistrationBean registrationBean = new FilterRegistrationBean();
		registrationBean.setFilter(filter);
		List<String> urlPatterns=new ArrayList<>();
		urlPatterns.add("/*");//拦截路径，可以添加多个
		registrationBean.setUrlPatterns(urlPatterns);
		registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST));
		registrationBean.setOrder(Ordered.HIGHEST_PRECEDENCE);//最高优先级
		return registrationBean;
	}

}
