/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon;

import com.netflix.config.AggregatedConfiguration;
import com.netflix.config.ConcurrentCompositeConfiguration;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.DeploymentContext;
import com.netflix.config.DynamicProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicURLConfiguration;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.IPing;
import com.netflix.loadbalancer.IPingStrategy;
import com.netflix.loadbalancer.IRule;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.EnvironmentConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.netflix.archaius.ConfigurableEnvironmentConfiguration;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.ReflectionUtils;

@Configuration
@ConditionalOnClass(value={IPing.class, IRule.class, ILoadBalancer.class, IPingStrategy.class})
public class RibbonEnvironmentFixBootstrapConfiguration {
    private static final AtomicBoolean initialized = new AtomicBoolean(false);
    private static final Logger log = LoggerFactory.getLogger(RibbonEnvironmentFixBootstrapConfiguration.class);
    @Autowired
    private ConfigurableEnvironment env;
    private DynamicURLConfiguration defaultURLConfig;
    @Autowired(required=false)
    private List<AbstractConfiguration> externalConfigurations = new ArrayList<AbstractConfiguration>();

    @PreDestroy
    public void close() {
        if (this.defaultURLConfig != null) {
            this.defaultURLConfig.stopLoading();
        }
        RibbonEnvironmentFixBootstrapConfiguration.setStatic(ConfigurationManager.class, "instance", null);
        RibbonEnvironmentFixBootstrapConfiguration.setStatic(ConfigurationManager.class, "customConfigurationInstalled", false);
        RibbonEnvironmentFixBootstrapConfiguration.setStatic(DynamicPropertyFactory.class, "config", null);
        RibbonEnvironmentFixBootstrapConfiguration.setStatic(DynamicPropertyFactory.class, "initializedWithDefaultConfig", false);
        RibbonEnvironmentFixBootstrapConfiguration.setStatic(DynamicProperty.class, "dynamicPropertySupportImpl", null);
        initialized.compareAndSet(true, false);
    }

    @PostConstruct
    public ConfigurableEnvironmentConfiguration configurableEnvironmentConfiguration() {
        ConfigurableEnvironmentConfiguration envConfig = new ConfigurableEnvironmentConfiguration(this.env);
        this.configureArchaius(envConfig);
        return envConfig;
    }

    protected void configureArchaius(ConfigurableEnvironmentConfiguration envConfig) {
        if (initialized.compareAndSet(false, true)) {
            String appName = this.env.getProperty("spring.application.name");
            if (appName == null) {
                appName = "application";
                log.warn("No spring.application.name found, defaulting to 'application'");
            }
            System.setProperty(DeploymentContext.ContextKey.appId.getKey(), appName);
            ConcurrentCompositeConfiguration config = new ConcurrentCompositeConfiguration();
            if (this.externalConfigurations != null) {
                for (AbstractConfiguration externalConfig : this.externalConfigurations) {
                    config.addConfiguration(externalConfig);
                }
            }
            config.addConfiguration((AbstractConfiguration)envConfig, ConfigurableEnvironmentConfiguration.class.getSimpleName());
            this.defaultURLConfig = new DynamicURLConfiguration();
            try {
                config.addConfiguration((AbstractConfiguration)this.defaultURLConfig, "archaius.dynamicPropertyFactory.URL_CONFIG");
            }
            catch (Throwable ex) {
                log.error("Cannot create config from " + this.defaultURLConfig, ex);
            }
            if (!Boolean.getBoolean("archaius.dynamicProperty.disableSystemConfig")) {
                SystemConfiguration sysConfig = new SystemConfiguration();
                config.addConfiguration((AbstractConfiguration)sysConfig, "archaius.dynamicPropertyFactory.SYS_CONFIG");
            }
            if (!Boolean.getBoolean("archaius.dynamicProperty.disableEnvironmentConfig")) {
                EnvironmentConfiguration environmentConfiguration = new EnvironmentConfiguration();
                config.addConfiguration((AbstractConfiguration)environmentConfiguration, "archaius.dynamicPropertyFactory.ENV_CONFIG");
            }
            ConcurrentCompositeConfiguration appOverrideConfig = new ConcurrentCompositeConfiguration();
            config.addConfiguration((AbstractConfiguration)appOverrideConfig, "APPLICATION_PROPERTIES");
            config.setContainerConfigurationIndex(config.getIndexOfConfiguration((AbstractConfiguration)appOverrideConfig));
            this.addArchaiusConfiguration(config);
        } else {
            log.warn("Netflix ConfigurationManager has already been installed, unable to re-install");
        }
    }

    private void addArchaiusConfiguration(ConcurrentCompositeConfiguration config) {
        if (ConfigurationManager.isConfigurationInstalled()) {
            AbstractConfiguration installedConfiguration = ConfigurationManager.getConfigInstance();
            if (installedConfiguration instanceof ConcurrentCompositeConfiguration) {
                ConcurrentCompositeConfiguration configInstance = (ConcurrentCompositeConfiguration)installedConfiguration;
                configInstance.addConfiguration((AbstractConfiguration)config);
            } else {
                installedConfiguration.append((org.apache.commons.configuration.Configuration)config);
                if (!(installedConfiguration instanceof AggregatedConfiguration)) {
                    log.warn("Appending a configuration to an existing non-aggregated installed configuration will have no effect");
                }
            }
        } else {
            ConfigurationManager.install((AbstractConfiguration)config);
        }
    }

    private static void setStatic(Class<?> type, String name, Object value) {
        Field field = ReflectionUtils.findField(type, (String)name);
        ReflectionUtils.makeAccessible((Field)field);
        ReflectionUtils.setField((Field)field, null, (Object)value);
    }
}

