/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import cn.com.duibaboot.ext.autoconfigure.core.utils.SpringBootUtils;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.AbstractLoadBalancerPing;
import com.netflix.loadbalancer.BaseLoadBalancer;
import com.netflix.loadbalancer.Server;
import com.netflix.niws.loadbalancer.DiscoveryEnabledServer;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RibbonPing
extends AbstractLoadBalancerPing {
    private static final Logger logger = LoggerFactory.getLogger(RibbonPing.class);
    private static final CloseableHttpClient httpClient;
    BaseLoadBalancer lb = null;

    public BaseLoadBalancer getLb() {
        return this.lb;
    }

    public void setLb(BaseLoadBalancer lb) {
        this.lb = lb;
    }

    public boolean isAlive(Server server) {
        boolean isAlive = true;
        if (server != null && server instanceof DiscoveryEnabledServer) {
            InstanceInfo.InstanceStatus status;
            DiscoveryEnabledServer dServer = (DiscoveryEnabledServer)server;
            InstanceInfo instanceInfo = dServer.getInstanceInfo();
            if (instanceInfo != null && (status = instanceInfo.getStatus()) != null) {
                isAlive = status.equals((Object)InstanceInfo.InstanceStatus.UP);
            }
            IOException exception = null;
            String monitorCheckResult = null;
            if (isAlive) {
                String monitorCheckUrl = dServer.getInstanceInfo().getHomePageUrl();
                if (!monitorCheckUrl.endsWith("/")) {
                    monitorCheckUrl = monitorCheckUrl + "/";
                }
                monitorCheckUrl = monitorCheckUrl + "monitor/check";
                HttpGet httpGet = new HttpGet(monitorCheckUrl);
                try {
                    CloseableHttpResponse resp = httpClient.execute((HttpUriRequest)httpGet);
                    int statusCode = resp.getStatusLine().getStatusCode();
                    monitorCheckResult = IOUtils.toString((InputStream)resp.getEntity().getContent());
                    resp.getEntity().getContent().close();
                    if (statusCode == 404) {
                        logger.error("server: {}({}) has no http endpoint /monitor/check, please setup,get help from here: http://cf.dui88.com/pages/viewpage.action?pageId=5252873", (Object)dServer.getInstanceInfo().getAppName(), (Object)dServer.getHostPort());
                        isAlive = true;
                    } else if (statusCode >= 500) {
                        isAlive = false;
                    }
                }
                catch (MalformedURLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    isAlive = false;
                }
                catch (IOException e) {
                    isAlive = false;
                    exception = e;
                }
            }
            if (server.isAlive() != isAlive) {
                if (exception != null) {
                    logger.info("[ping in ribbon] detect that {}[{}] is {}\uff0cexceptionClass:{}, errorMsg:{}", new Object[]{instanceInfo.getAppName(), server.getHostPort(), isAlive ? "alive" : "dead", exception.getClass().getName(), exception.getMessage()});
                } else {
                    logger.info("[ping in ribbon] detect that {}[{}] is {}, [/monitor/check] result:{}", new Object[]{instanceInfo.getAppName(), server.getHostPort(), isAlive ? "alive" : "dead", monitorCheckResult});
                }
            }
        }
        return isAlive;
    }

    public void initWithNiwsConfig(IClientConfig clientConfig) {
    }

    public void destroy() {
        try {
            httpClient.close();
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
        }
    }

    static {
        if (SpringBootUtils.isJarInJarMode()) {
            LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
            loggerContext.getLogger(RibbonPing.class).setLevel(Level.INFO);
        }
        httpClient = HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(100).setSocketTimeout(100).setConnectionRequestTimeout(100).build()).setMaxConnPerRoute(1).setMaxConnTotal(1000).setUserAgent("RibbonPing").disableAutomaticRetries().disableCookieManagement().useSystemProperties().setKeepAliveStrategy((ConnectionKeepAliveStrategy)new DefaultConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                long time = super.getKeepAliveDuration(response, context);
                if (time == -1L) {
                    time = 30000L;
                }
                return time;
            }
        }).build();
    }
}

