/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.web.container;

import cn.com.duiba.wolf.threadpool.MonitorRunnable;
import cn.com.duiba.wolf.threadpool.NamedThreadFactory;
import cn.com.duibaboot.ext.autoconfigure.web.container.TomcatCustomizer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.context.embedded.ConfigurableEmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerCustomizer;

public abstract class SpecifiedEmbeddedServletContainerCustomizer<T extends ConfigurableEmbeddedServletContainer>
implements EmbeddedServletContainerCustomizer,
DisposableBean {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String HTTP_FAIL_FAST_THREAD_NAME_PREFIX = "HttpFailFastThread";
    private Class<T> factoryClass;
    private volatile ThreadPoolExecutor httpExecutor;
    private volatile ThreadPoolExecutor httpFailFastExecutor;
    private volatile ScheduledExecutorService scheduledExecutorService;

    public SpecifiedEmbeddedServletContainerCustomizer(Class<T> factoryClass) {
        this.factoryClass = factoryClass;
    }

    public void customize(ConfigurableEmbeddedServletContainer container) {
        if (this.factoryClass.isInstance(container)) {
            this.customizeSpecified(container);
        }
    }

    public abstract void customizeSpecified(T var1);

    public abstract void shutdownGracefully();

    public void failFastToHttpExecutor(ThreadPoolExecutor httpExecutor) {
        this.httpExecutor = httpExecutor;
        this.startFailFastService();
    }

    public void destroy() throws Exception {
        this.shutdownGracefully();
        this.stopFailFastService();
    }

    private BlockingQueue<Runnable> getQueueOfHttpExecutor() {
        ThreadPoolExecutor temp = this.httpExecutor;
        ThreadPoolExecutor ex = temp;
        if (ex instanceof TomcatCustomizer.TomcatMonitorThreadPoolExecutor ? ((TomcatCustomizer.TomcatMonitorThreadPoolExecutor)((Object)ex)).getSubmittedCount() < ex.getMaximumPoolSize() : ex.getActiveCount() < ex.getMaximumPoolSize()) {
            return null;
        }
        return ex.getQueue();
    }

    private void startFailFastService() {
        if (this.httpFailFastExecutor != null) {
            return;
        }
        this.httpFailFastExecutor = new ThreadPoolExecutor(1, 3, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100), (ThreadFactory)new NamedThreadFactory(HTTP_FAIL_FAST_THREAD_NAME_PREFIX));
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("HttpFailFastScheduledThread"));
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                Runnable runnable;
                BlockingQueue workQueue = SpecifiedEmbeddedServletContainerCustomizer.this.getQueueOfHttpExecutor();
                if (workQueue == null || workQueue.isEmpty()) {
                    return;
                }
                while (!workQueue.isEmpty() && (runnable = (Runnable)workQueue.peek()) != null) {
                    boolean needMoveIntoAnotherPool = false;
                    if (runnable instanceof MonitorRunnable) {
                        MonitorRunnable mr = (MonitorRunnable)runnable;
                        long createTimeMillis = mr.getSubmitTimeMillis();
                        if (System.currentTimeMillis() - createTimeMillis > 50L) {
                            needMoveIntoAnotherPool = true;
                        }
                    } else {
                        SpecifiedEmbeddedServletContainerCustomizer.this.logger.warn("[NOTIFYME]runnable from httpExecutor is not instanceof MonitorRunnable.");
                    }
                    if (!needMoveIntoAnotherPool) break;
                    boolean removed = workQueue.remove(runnable);
                    if (!removed) continue;
                    try {
                        SpecifiedEmbeddedServletContainerCustomizer.this.httpFailFastExecutor.execute(runnable);
                    }
                    catch (RejectedExecutionException e) {
                        SpecifiedEmbeddedServletContainerCustomizer.this.logger.warn("[NOTIFYME]put http thread into HttpFailFastThread failed,this will never happen", (Throwable)e);
                    }
                }
            }
        }, 1000L, 10L, TimeUnit.MILLISECONDS);
    }

    private void stopFailFastService() {
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdownNow();
        }
        if (this.httpFailFastExecutor != null) {
            this.httpFailFastExecutor.shutdownNow();
        }
    }
}

