/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.nustaq.serialization.serializers;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import shaded.org.nustaq.serialization.FSTBasicObjectSerializer;
import shaded.org.nustaq.serialization.FSTClazzInfo;
import shaded.org.nustaq.serialization.FSTObjectInput;
import shaded.org.nustaq.serialization.FSTObjectOutput;

public class FSTClassSerializer
extends FSTBasicObjectSerializer {
    private final Map<String, Class> primitiveMap = new HashMap<String, Class>();

    public FSTClassSerializer() {
        Class[] primitives;
        for (Class cls : primitives = new Class[]{Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Character.TYPE, Boolean.TYPE, Void.TYPE}) {
            this.primitiveMap.put(cls.getName(), cls);
        }
    }

    @Override
    public void writeObject(FSTObjectOutput out, Object toWrite, FSTClazzInfo clzInfo, FSTClazzInfo.FSTFieldInfo referencedBy, int streamPosition) throws IOException {
        Class cls = (Class)toWrite;
        out.writeBoolean(cls.isPrimitive());
        out.writeStringUTF(cls.getName());
    }

    @Override
    public Object instantiate(Class objectClass, FSTObjectInput in, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo referencee, int streamPosition) throws Exception {
        boolean isPrimitive = in.readBoolean();
        String name = in.readStringUTF();
        Class cls = isPrimitive ? this.primitiveMap.get(name) : in.getClassForName(name);
        in.registerObject(cls, streamPosition, serializationInfo, referencee);
        return cls;
    }

    @Override
    public boolean alwaysCopy() {
        return false;
    }
}

