/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.etcd;

import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.hystrix.HystrixPropertiesStrategyWithReloadableCache;
import cn.com.duibaboot.ext.autoconfigure.etcd.EtcdEndpoint;
import cn.com.duibaboot.ext.autoconfigure.etcd.EtcdHealthIndicator;
import cn.com.duibaboot.ext.autoconfigure.etcd.EtcdProperties;
import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesStrategy;
import java.net.URI;
import mousio.etcd4j.EtcdClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={EtcdProperties.class})
@ConditionalOnClass(value={EtcdClient.class})
@ConditionalOnProperty(name={"spring.cloud.etcd.uris"}, matchIfMissing=false)
public class EtcdAutoConfiguration {
    @Autowired
    protected EtcdProperties etcdProperties;

    @Bean
    @ConditionalOnMissingBean
    public EtcdClient etcdClient() {
        HystrixPlugins.getInstance().registerPropertiesStrategy((HystrixPropertiesStrategy)new HystrixPropertiesStrategyWithReloadableCache());
        return new EtcdClient(this.etcdProperties.getUris().toArray(new URI[0]));
    }

    @Bean
    @ConditionalOnMissingBean
    public EtcdEndpoint etcdEndpoint() {
        return new EtcdEndpoint(this.etcdClient());
    }

    @Bean
    @ConditionalOnMissingBean
    public EtcdHealthIndicator etcdHealthIndicator(EtcdClient client) {
        return new EtcdHealthIndicator(client);
    }
}

