/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.etcd;

import mousio.etcd4j.EtcdClient;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;

public class EtcdHealthIndicator
extends AbstractHealthIndicator {
    private final EtcdClient client;

    public EtcdHealthIndicator(EtcdClient client) {
        this.client = client;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        try {
            String version = this.client.getVersion();
            builder.withDetail("version", (Object)version).up();
        }
        catch (Exception e) {
            builder.down(e);
        }
    }

    public EtcdClient getClient() {
        return this.client;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        EtcdHealthIndicator that = (EtcdHealthIndicator)((Object)o);
        return this.client.equals(that.client);
    }

    public int hashCode() {
        return this.client.hashCode();
    }

    public String toString() {
        return String.format("EtcdHealthIndicator{client=%s}", this.client);
    }
}

