/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.etcd;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="spring.cloud.etcd")
public class EtcdProperties {
    @NotNull
    private List<URI> uris = Arrays.asList(URI.create("http://localhost:4001"));
    private boolean enabled = true;

    public EtcdProperties() {
    }

    public EtcdProperties(List<URI> uris, boolean enabled) {
        this.uris = uris;
        this.enabled = enabled;
    }

    public List<URI> getUris() {
        return this.uris;
    }

    public void setUris(List<URI> uris) {
        this.uris = uris;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EtcdProperties that = (EtcdProperties)o;
        if (this.enabled != that.enabled) {
            return false;
        }
        return this.uris != null ? this.uris.equals(that.uris) : that.uris == null;
    }

    public int hashCode() {
        int result = this.uris != null ? this.uris.hashCode() : 0;
        result = 31 * result + (this.enabled ? 1 : 0);
        return result;
    }

    public String toString() {
        return String.format("EtcdProperties{uris=%s, enabled=%s}", this.uris, this.enabled);
    }
}

