/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.etcd.cloud;

import cn.com.duibaboot.ext.autoconfigure.etcd.cloud.EtcdConfigProperties;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import mousio.etcd4j.EtcdClient;
import mousio.etcd4j.responses.EtcdException;
import mousio.etcd4j.responses.EtcdKeysResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class EtcdPropertySource
extends EnumerablePropertySource<EtcdClient> {
    private static final Log log = LogFactory.getLog(EtcdPropertySource.class);
    private final Map<String, String> properties = new HashMap<String, String>();
    private final String prefix;
    private final EtcdConfigProperties config;

    public EtcdPropertySource(String root, EtcdClient source, EtcdConfigProperties config) {
        super(root, (Object)source);
        this.prefix = root.startsWith("/") ? root + "/" : "/" + root + "/";
        this.config = config;
    }

    public void init() {
        try {
            EtcdKeysResponse response = (EtcdKeysResponse)((EtcdClient)this.getSource()).getDir(this.getName()).recursive().timeout((long)this.config.getTimeout(), this.config.getTimeoutUnit()).send().get();
            if (response.node != null) {
                this.process(response.node);
            }
        }
        catch (EtcdException e) {
            if (e.errorCode == 100) {
                log.warn((Object)("Unable to init property source: " + this.getName() + ", " + e.getMessage()));
            } else {
                log.warn((Object)("Unable to init property source: " + this.getName()), (Throwable)e);
            }
        }
        catch (Exception e) {
            log.warn((Object)("Unable to init property source: " + this.getName()), (Throwable)e);
        }
    }

    public String[] getPropertyNames() {
        return this.properties.keySet().toArray(new String[0]);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    private void process(EtcdKeysResponse.EtcdNode root) {
        if (!StringUtils.isEmpty((Object)root.value)) {
            String key = root.key.substring(this.prefix.length());
            this.properties.put(key.replace("/", "."), root.value);
        }
        if (!CollectionUtils.isEmpty((Collection)root.nodes)) {
            for (EtcdKeysResponse.EtcdNode node : root.nodes) {
                this.process(node);
            }
        }
    }
}

