/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.rocketmq;

import cn.com.duibaboot.ext.autoconfigure.core.EarlyClose;
import cn.com.duibaboot.ext.autoconfigure.rocketmq.DefaultMQProducerWrapper;
import cn.com.duibaboot.ext.autoconfigure.rocketmq.RocketMqProperties;
import java.lang.reflect.Field;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.MessageListener;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.consumer.listener.MessageListenerOrderly;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ReflectionUtils;

@Configuration
@EnableConfigurationProperties(value={RocketMqProperties.class})
public class RocketMqAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(RocketMqAutoConfiguration.class);

    private static class RocketMqConsumerFactoryBean
    extends EarlyClose
    implements FactoryBean<DefaultMQPushConsumer>,
    InitializingBean {
        @Resource
        private ApplicationContext applicationContext;
        private DefaultMQPushConsumer rocketMqConsumer;
        private RocketMqProperties rocketMqProperties;
        private RocketMqProperties.ConsumerProperties consumerProperties;
        private String messageListenerBeanId;

        public RocketMqConsumerFactoryBean(RocketMqProperties rocketMqProperties, int consumerPropertiesIndex) {
            this.rocketMqProperties = rocketMqProperties;
            if (consumerPropertiesIndex == -1) {
                this.consumerProperties = rocketMqProperties.getConsumer();
                this.messageListenerBeanId = "bootRocketMqMessageListener";
            } else {
                this.consumerProperties = rocketMqProperties.getExtraConsumer()[consumerPropertiesIndex];
                this.messageListenerBeanId = "extraBootRocketMqMessageListener" + consumerPropertiesIndex;
            }
        }

        public void afterPropertiesSet() throws Exception {
            String[] topicArr;
            MessageListener rocketMqMessageListener;
            try {
                rocketMqMessageListener = (MessageListener)this.applicationContext.getBean(this.messageListenerBeanId, MessageListener.class);
            }
            catch (NoSuchBeanDefinitionException e) {
                logger.error("", (Throwable)new IllegalStateException("bean id:[" + this.messageListenerBeanId + "] class:[org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently] is not exist in spring's context, \u8bf7\u58f0\u660e\uff0c\u5426\u5219\u4e0d\u4f1a\u542f\u7528rocketmq\u6d88\u8d39!!!\uff0c\u8bf7\u53c2\u8003: http://gitlab2.dui88.com/basic_platform/spring-boot-ext/wikis/Starter%E7%89%B9%E6%80%A7/_rocketmq%E3%80%90%E5%BC%80%E6%BA%90RocketMQ%E3%80%91"));
                return;
            }
            DefaultMQPushConsumer consumer = new DefaultMQPushConsumer(this.consumerProperties.getGroup());
            consumer.setNamesrvAddr(this.rocketMqProperties.getNameSrvAddr());
            consumer.setMaxReconsumeTimes(this.consumerProperties.getMaxReconsumeTimes().intValue());
            if (this.consumerProperties.getConsumeThreadNums() > 0) {
                consumer.setConsumeThreadMin(this.consumerProperties.getConsumeThreadNums().intValue());
                consumer.setConsumeThreadMax(Math.max(this.consumerProperties.getConsumeThreadNums(), 64));
            }
            consumer.setMessageModel(this.consumerProperties.getMessageModelEnum());
            consumer.setConsumeMessageBatchMaxSize(1);
            String topics = this.consumerProperties.getTopics();
            for (String topic : topicArr = topics.split(",")) {
                consumer.subscribe(topic, "*");
            }
            if (rocketMqMessageListener instanceof MessageListenerConcurrently) {
                consumer.registerMessageListener((MessageListenerConcurrently)rocketMqMessageListener);
            } else if (rocketMqMessageListener instanceof MessageListenerOrderly) {
                consumer.registerMessageListener((MessageListenerOrderly)rocketMqMessageListener);
            }
            consumer.start();
            this.rocketMqConsumer = consumer;
        }

        public DefaultMQPushConsumer getObject() throws Exception {
            return this.rocketMqConsumer;
        }

        public Class<?> getObjectType() {
            return DefaultMQPushConsumer.class;
        }

        public boolean isSingleton() {
            return true;
        }

        public void stop() {
            if (this.rocketMqConsumer != null) {
                this.rocketMqConsumer.shutdown();
                this.awaitShutdown(this.rocketMqConsumer, 3);
            }
        }

        private void awaitShutdown(DefaultMQPushConsumer defaultMQPushConsumer, int awaitMaxSeconds) {
            Field fieldDefaultMQPushConsumerImpl = ReflectionUtils.findField(defaultMQPushConsumer.getClass(), (String)"defaultMQPushConsumerImpl");
            fieldDefaultMQPushConsumerImpl.setAccessible(true);
            Object defaultMQPushConsumerImpl = ReflectionUtils.getField((Field)fieldDefaultMQPushConsumerImpl, (Object)defaultMQPushConsumer);
            Field fieldConsumeMessageService = ReflectionUtils.findField(defaultMQPushConsumerImpl.getClass(), (String)"consumeMessageService");
            fieldConsumeMessageService.setAccessible(true);
            Object consumeMessageService = ReflectionUtils.getField((Field)fieldConsumeMessageService, (Object)defaultMQPushConsumerImpl);
            Field fieldConsumeExecutor = ReflectionUtils.findField(consumeMessageService.getClass(), (String)"consumeExecutor");
            fieldConsumeExecutor.setAccessible(true);
            ThreadPoolExecutor consumeExecutor = (ThreadPoolExecutor)ReflectionUtils.getField((Field)fieldConsumeExecutor, (Object)consumeMessageService);
            try {
                consumeExecutor.awaitTermination(awaitMaxSeconds, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public int getPhase() {
            return 1;
        }
    }

    @Configuration
    @ConditionalOnClass(value={DefaultMQPushConsumer.class})
    protected static class RocketMqConsumerConfigurator
    extends RocketMqClientConfiguration {
        protected RocketMqConsumerConfigurator() {
        }

        @Bean(name={"rocketMqConsumer"})
        @ConditionalOnMissingBean(name={"rocketMqConsumer"})
        @ConditionalOnProperty(name={"duiba.rocketmq.consumer.enable"}, havingValue="true", matchIfMissing=false)
        public FactoryBean<DefaultMQPushConsumer> rocketMqConsumer() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
            return new RocketMqConsumerFactoryBean(this.rocketMqProperties, -1);
        }

        @Bean(name={"extraRocketMqConsumer0"})
        @ConditionalOnMissingBean(name={"extraRocketMqConsumer0"})
        @ConditionalOnProperty(name={"duiba.rocketmq.extra-consumer[0].enable"}, havingValue="true", matchIfMissing=false)
        public FactoryBean<DefaultMQPushConsumer> extraRocketMqConsumer0() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
            return new RocketMqConsumerFactoryBean(this.rocketMqProperties, 0);
        }

        @Bean(name={"extraRocketMqConsumer1"})
        @ConditionalOnMissingBean(name={"extraRocketMqConsumer1"})
        @ConditionalOnProperty(name={"duiba.rocketmq.extra-consumer[1].enable"}, havingValue="true", matchIfMissing=false)
        public FactoryBean<DefaultMQPushConsumer> extraRocketMqConsumer1() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
            return new RocketMqConsumerFactoryBean(this.rocketMqProperties, 1);
        }

        @Bean(name={"extraRocketMqConsumer2"})
        @ConditionalOnMissingBean(name={"extraRocketMqConsumer2"})
        @ConditionalOnProperty(name={"duiba.rocketmq.extra-consumer[2].enable"}, havingValue="true", matchIfMissing=false)
        public FactoryBean<DefaultMQPushConsumer> extraRocketMqConsumer2() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
            return new RocketMqConsumerFactoryBean(this.rocketMqProperties, 2);
        }
    }

    @Configuration
    @ConditionalOnClass(value={DefaultMQProducer.class})
    @ConditionalOnMissingBean(name={"rocketMqProducer"})
    @ConditionalOnProperty(name={"duiba.rocketmq.producer.enable"}, havingValue="true", matchIfMissing=false)
    protected static class RocketMqProducerConfigurator
    extends RocketMqClientConfiguration {
        protected RocketMqProducerConfigurator() {
        }

        @Bean(name={"rocketMqProducer"}, destroyMethod="shutdown")
        public DefaultMQProducer rocketMqProducer() throws MQClientException {
            DefaultMQProducerWrapper p = new DefaultMQProducerWrapper();
            p.setProducerGroup(this.rocketMqProperties.getProducer().getGroup());
            p.setNamesrvAddr(this.rocketMqProperties.getNameSrvAddr());
            p.setSendMsgTimeout(this.rocketMqProperties.getProducer().getSendMsgTimeoutMillis());
            p.start();
            return p;
        }
    }

    protected static abstract class RocketMqClientConfiguration {
        @Autowired
        protected RocketMqProperties rocketMqProperties;

        protected RocketMqClientConfiguration() {
        }
    }
}

