package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign.hystrix;

import java.util.Map;

import com.alibaba.fastjson.JSON;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.jmx.export.annotation.ManagedResource;

/**
 * Created by hujinliang on 2018/1/22.
 */
@ManagedResource
public class CircuitBreakerEndpoint extends AbstractEndpoint<String> {
    private Map<String,Object> circuitBreakerInfo;

    public CircuitBreakerEndpoint(Map<String,Object> circuitBreakerInfo) {
        super("circuitBreaker");
        this.circuitBreakerInfo = circuitBreakerInfo;
    }


    @Override
    public String invoke() {
        return JSON.toJSONString(circuitBreakerInfo);
    }

}
