package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign.hystrix;

import java.util.Map;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.contrib.javanica.conf.HystrixPropertiesManager;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesFactory;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.jmx.export.annotation.ManagedResource;

/**
 * Created by hujinliang on 2018/1/22.
 */
@ManagedResource
public class CircuitBreakerEndpoint extends AbstractEndpoint<String> {
    private Map<String,Object> circuitBreakerInfo;

    public CircuitBreakerEndpoint(Map<String,Object> circuitBreakerInfo) {
        super("circuitBreaker");
        this.circuitBreakerInfo = circuitBreakerInfo;
    }


    @Override
    public String invoke() {
        Map<String, Object> circuitBreakerMap = Maps.newHashMap(circuitBreakerInfo);
        refreshProperty(circuitBreakerMap, 0);
        return JSON.toJSONString(circuitBreakerMap);
    }

    private void refreshProperty(Map<String, Object> circuitBreakerMap, int i) {
        for (Map.Entry<String, Object> kv : circuitBreakerMap.entrySet()) {
            if (i == 2) {//应用名-线程池组名称-Command名称
                if(kv.getKey().equals(HystrixPropertiesManager.CORE_SIZE))return;
                if(kv.getKey().equals(HystrixPropertiesManager.MAXIMUM_SIZE))return;
                if(kv.getKey().equals(HystrixPropertiesManager.MAX_QUEUE_SIZE))return;
                HystrixCommandProperties commandProperties = HystrixPropertiesFactory.getCommandProperties(HystrixCommandKey.Factory.asKey(kv.getKey()), null);
                Map<String, Object> commandProperty = Maps.newHashMap();
                commandProperty.put(HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, commandProperties.executionTimeoutInMilliseconds().get());
                commandProperty.put(HystrixPropertiesManager.CIRCUIT_BREAKER_FORCE_OPEN, commandProperties.circuitBreakerForceOpen().get());
                kv.setValue(commandProperty);
            } else {
                Map<String, Object> val = (Map<String, Object>) kv.getValue();
                if (i == 1) {//应用名-线程池组名称
                    HystrixThreadPoolProperties threadProperties = HystrixPropertiesFactory.getThreadPoolProperties(HystrixThreadPoolKey.Factory.asKey(kv.getKey()), null);
                    val.put(HystrixPropertiesManager.CORE_SIZE, threadProperties.coreSize().get());
                    val.put(HystrixPropertiesManager.MAXIMUM_SIZE, threadProperties.maximumSize().get());
                    val.put(HystrixPropertiesManager.MAX_QUEUE_SIZE, threadProperties.maxQueueSize().get());
                }
                int next=i+1;
                refreshProperty(val, next);
            }
        }

    }

}
