package cn.com.duibaboot.ext.autoconfigure.xss;

import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign.CustomRequestInterceptor;
import cn.com.duibaboot.ext.autoconfigure.core.utils.HttpRequestUtils;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

/**
 * ClassName: XssFilter <br/>
 * date: 2016年12月8日 下午8:47:45 <br/>
 *
 * @version 
 */
public class XssFilter implements Filter {

	@Override
	public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
		HttpServletRequest request = (HttpServletRequest)req;
		if(isFeignRequest(request)){//如果是来自feign的spring-cloud接口调用，则不进行xss filter(否则处理json时会把双引号转义掉
			chain.doFilter(req, resp);
		}else {
			chain.doFilter(new XssHttpServletRequestWrapper((HttpServletRequest) req), resp);
		}
	}

	/**
	 * 判断是否是来自内网的Feign请求（spring-cloud调用）
	 * @param request
	 * @return
	 */
	private boolean isFeignRequest(HttpServletRequest request){
		if (!"true".equals(request.getHeader(CustomRequestInterceptor.X_RPC))) {
			return false;
		}

		//是feign调用的情况下还得验证请求来自内网，否则会有安全问题
		if(!HttpRequestUtils.isLanRequest(request)){
			return false;
		}

		return true;
	}

	@Override
	public void destroy() {
	}

	@Override
	public void init(FilterConfig arg0) throws ServletException {
	}

}
