/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.web.mvc;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.stereotype.Controller;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.RequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class CustomRequestMappingHandlerMapping
extends RequestMappingHandlerMapping {
    protected boolean isHandler(Class<?> beanType) {
        if (AnnotatedElementUtils.hasAnnotation(beanType, Controller.class)) {
            return true;
        }
        if (AnnotatedElementUtils.hasAnnotation(beanType, RequestMapping.class) && !beanType.isInterface()) {
            return !AnnotatedElementUtils.hasAnnotation(beanType, FeignClient.class) && !AnnotatedElementUtils.hasAnnotation(beanType, AdvancedFeignClient.class);
        }
        return false;
    }

    protected RequestMappingInfo getMappingForMethod(Method method, Class<?> handlerType) {
        RequestMapping requestMapping;
        boolean isAdvancedFeignClientMode = false;
        Class<?>[] interfaces = handlerType.getInterfaces();
        int interfaceCntWithFCAnno = 0;
        for (Class<?> clazz : interfaces) {
            if (!clazz.isAnnotationPresent(AdvancedFeignClient.class)) continue;
            isAdvancedFeignClientMode = true;
            ++interfaceCntWithFCAnno;
        }
        if (interfaceCntWithFCAnno > 1) {
            throw new IllegalStateException("the class:" + handlerType.getName() + " can only have one interface annotated with @AdvancedFeignClient");
        }
        if (!isAdvancedFeignClientMode) {
            return super.getMappingForMethod(method, handlerType);
        }
        Method methodInInterface = null;
        for (Class<?> clazz : interfaces) {
            if (!clazz.isAnnotationPresent(AdvancedFeignClient.class)) continue;
            try {
                methodInInterface = clazz.getMethod(method.getName(), method.getParameterTypes());
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (methodInInterface == null || methodInInterface.isDefault()) {
            return null;
        }
        RequestMappingInfo info = this.createRequestMappingInfo(methodInInterface);
        if (info == null) {
            String path = method.getName();
            RequestMapping requestMapping2 = this.genRequestMapping(path);
            info = this.createRequestMappingInfo(requestMapping2, method);
        } else if (info.getPatternsCondition().getPatterns().isEmpty() || StringUtils.isEmpty(info.getPatternsCondition().getPatterns().iterator().next())) {
            String path = method.getName();
            RequestMapping requestMapping3 = this.genRequestMapping(path);
            RequestMappingInfo otherInfo = this.createRequestMappingInfo(requestMapping3, method);
            info = otherInfo.combine(info);
        }
        RequestMappingInfo typeInfo = this.createRequestMappingInfo(methodInInterface.getDeclaringClass());
        if (typeInfo == null) {
            String path = StringUtils.uncapitalize((String)methodInInterface.getDeclaringClass().getSimpleName());
            requestMapping = this.genRequestMapping(path);
            typeInfo = this.createRequestMappingInfo(requestMapping, methodInInterface.getDeclaringClass());
        } else if (typeInfo.getPatternsCondition().getPatterns().isEmpty() || StringUtils.isEmpty(typeInfo.getPatternsCondition().getPatterns().iterator().next())) {
            String path = StringUtils.uncapitalize((String)methodInInterface.getDeclaringClass().getSimpleName());
            requestMapping = this.genRequestMapping(path);
            RequestMappingInfo otherTypeInfo = this.createRequestMappingInfo(requestMapping, methodInInterface.getDeclaringClass());
            typeInfo = otherTypeInfo.combine(typeInfo);
        }
        info = typeInfo.combine(info);
        return info;
    }

    private RequestMapping genRequestMapping(final String path) {
        return new RequestMapping(){

            public String[] value() {
                return new String[]{path};
            }

            public String[] path() {
                return this.value();
            }

            public RequestMethod[] method() {
                return new RequestMethod[0];
            }

            public String[] params() {
                return new String[0];
            }

            public String[] headers() {
                return new String[0];
            }

            public String[] consumes() {
                return new String[0];
            }

            public String[] produces() {
                return new String[0];
            }

            public String name() {
                return "";
            }

            public Class<? extends Annotation> annotationType() {
                return RequestMapping.class;
            }
        };
    }

    private RequestMappingInfo createRequestMappingInfo(RequestMapping requestMapping, AnnotatedElement element) {
        RequestCondition condition = element instanceof Class ? this.getCustomTypeCondition((Class)element) : this.getCustomMethodCondition((Method)element);
        return requestMapping != null ? this.createRequestMappingInfo(requestMapping, condition) : null;
    }

    private RequestMappingInfo createRequestMappingInfo(AnnotatedElement element) {
        RequestMapping requestMapping = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)element, RequestMapping.class);
        RequestCondition condition = element instanceof Class ? this.getCustomTypeCondition((Class)element) : this.getCustomMethodCondition((Method)element);
        return requestMapping != null ? this.createRequestMappingInfo(requestMapping, condition) : null;
    }

    protected HandlerMethod getHandlerInternal(HttpServletRequest request) throws Exception {
        HandlerMethod m = super.getHandlerInternal(request);
        if (m == null) {
            return m;
        }
        MethodParameter[] parameters = m.getMethodParameters();
        if (parameters == null) {
            return m;
        }
        this.injectParameterAnnotations(parameters);
        return m;
    }

    private void injectParameterAnnotations(MethodParameter[] parameters) throws IllegalAccessException, InvocationTargetException {
        for (MethodParameter p : parameters) {
            Method method = p.getMethod();
            if (method == null) continue;
            Field field = ReflectionUtils.findField(p.getClass(), (String)"parameterAnnotations");
            field.setAccessible(true);
            if (field.get(p) != null) continue;
            Method requestMappingAnnotatedMethod = null;
            if (!this.isRequestMappingAnnotated(method)) {
                Class<?>[] interfaces = method.getDeclaringClass().getInterfaces();
                Class<?> superClass = method.getDeclaringClass().getSuperclass();
                ArrayList classesToSearch = new ArrayList();
                if (superClass != null || superClass != Object.class) {
                    classesToSearch.add(superClass);
                }
                classesToSearch.addAll(Arrays.asList(interfaces));
                for (Class clazz : classesToSearch) {
                    try {
                        Method superMethod = clazz.getMethod(method.getName(), method.getParameterTypes());
                        if (!this.isRequestMappingAnnotated(superMethod)) continue;
                        requestMappingAnnotatedMethod = superMethod;
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                }
            }
            if (requestMappingAnnotatedMethod == null) continue;
            Annotation[] parameterAnnotations = null;
            Annotation[][] annotationArray = requestMappingAnnotatedMethod.getParameterAnnotations();
            if (p.getParameterIndex() >= 0 && p.getParameterIndex() < annotationArray.length) {
                Method adaptAnnotationArrayMethod = ReflectionUtils.findMethod(p.getClass(), (String)"adaptAnnotationArray", (Class[])new Class[]{Annotation[].class});
                adaptAnnotationArrayMethod.setAccessible(true);
                Annotation[] annotationArray2 = annotationArray[p.getParameterIndex()];
                Object[] args = new Object[]{annotationArray2};
                parameterAnnotations = (Annotation[])adaptAnnotationArrayMethod.invoke((Object)p, args);
            } else {
                parameterAnnotations = new Annotation[]{};
            }
            field.set(p, parameterAnnotations);
            p.getParameterAnnotations();
        }
    }

    private boolean isRequestMappingAnnotated(Method m) {
        Annotation[] arr;
        for (Annotation a : arr = m.getAnnotations()) {
            if (!(a instanceof RequestMapping) && a.getClass().getAnnotation(RequestMapping.class) == null) continue;
            return true;
        }
        return false;
    }
}

