package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon;

import com.netflix.client.IClientConfigAware;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.discovery.EurekaClient;
import com.netflix.loadbalancer.ConfigurationBasedServerList;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerList;
import com.netflix.niws.loadbalancer.DiscoveryEnabledNIWSServerList;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.netflix.ribbon.eureka.DomainExtractingServerList;

import javax.inject.Provider;
import java.util.List;

public class CustomRibbonServerList implements ServerList<Server>, IClientConfigAware, InitializingBean {

    private Logger logger = LoggerFactory.getLogger(CustomRibbonServerList.class);

    private IClientConfig clientConfig;

    private ServerList<? extends Server> delegate;

    @Value("${ribbon.eureka.approximateZoneFromHostname:false}")
    private boolean approximateZoneFromHostname = false;

    @Autowired(required = false)
    private Provider<EurekaClient> eurekaClientProvider;

    @Override
    public void initWithNiwsConfig(IClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        String clientName = clientConfig.getClientName();//eg. stock-service
        String listOfServers = clientConfig.get(CommonClientConfigKey.ListOfServers);
        if(!StringUtils.isBlank(listOfServers)){
            ConfigurationBasedServerList serverList = new ConfigurationBasedServerList();
            serverList.initWithNiwsConfig(clientConfig);
            delegate = serverList;
            logger.info("检测到{}强制指定调用{}", clientName, listOfServers);
        }else{
            DiscoveryEnabledNIWSServerList discoveryServerList = new DiscoveryEnabledNIWSServerList(
                    clientConfig, eurekaClientProvider);
            DomainExtractingServerList serverList = new DomainExtractingServerList(
                    discoveryServerList, clientConfig, this.approximateZoneFromHostname);
            delegate = serverList;
        }
    }

    @Override
    public List<Server> getInitialListOfServers() {
        return (List<Server>) delegate.getInitialListOfServers();
    }

    @Override
    public List<Server> getUpdatedListOfServers() {
        return (List<Server>) delegate.getUpdatedListOfServers();
    }

}
