package cn.com.duibaboot.ext.autoconfigure.perftest.guava;

import java.lang.reflect.Method;

import cn.com.duiba.boot.perftest.PerfTestContext;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.EnhancedInstance;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.InstanceMethodsAroundInterceptor;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.MethodInterceptResult;
import com.alibaba.ttl.TransmittableThreadLocal;
import com.google.common.base.MoreObjects;

/**
 * 拦截guava的CacheLoader的实现类,方法执行前设置PerfTestMode为false，保证所有的是缓存回源(比如数据库、mongodb等)都是正式数据,防止影响线上服务器的内存数据
 */
public class GuavaCacheInterceptor implements InstanceMethodsAroundInterceptor {
    private final TransmittableThreadLocal<Integer> perfMode = new TransmittableThreadLocal<>();
    @Override
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments,
                             Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        boolean isPerf = PerfTestContext.isCurrentInPerfTestMode();
        if (isPerf) {
            //guava加载缓存前先清空压测标记（加载完成后会还原此标记），以让后续加载数据走主库
            Integer state = MoreObjects.firstNonNull(perfMode.get(), 0);
            perfMode.set(++state);
            if (state > 1) return;
            PerfTestContext.debugInfo("Guava Load&Reload");
            PerfTestContext._setPerfTestMode(false);
        }
    }

    @Override
    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments,
                              Class<?>[] argumentsTypes, Object ret) throws Throwable {
        if (perfMode.get() != null) {
            Integer state = perfMode.get();
            perfMode.set(--state);
            if (state == 0) {
                PerfTestContext._setPerfTestMode(true);
                perfMode.remove();
            }
        }
        return ret;
    }

    @Override
    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments,
                                      Class<?>[] argumentsTypes, Throwable t) {
    }
}
