/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.etcd.cloud;

import cn.com.duibaboot.ext.autoconfigure.etcd.cloud.EtcdConfigProperties;
import cn.com.duibaboot.ext.autoconfigure.etcd.cloud.EtcdPropertySource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mousio.etcd4j.EtcdClient;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;

public class EtcdPropertySourceLocator
implements PropertySourceLocator {
    private final EtcdClient etcd;
    private final EtcdConfigProperties properties;

    public EtcdPropertySourceLocator(EtcdClient etcd, EtcdConfigProperties properties) {
        this.etcd = etcd;
        this.properties = properties;
    }

    public PropertySource<?> locate(Environment environment) {
        if (environment instanceof ConfigurableEnvironment) {
            ConfigurableEnvironment env = (ConfigurableEnvironment)environment;
            String[] profiles = env.getActiveProfiles();
            ArrayList<String> contexts = new ArrayList<String>();
            this.setupContext(contexts, profiles, this.properties.getPrefix(), this.properties.getDefaultContext());
            this.setupContext(contexts, profiles, this.properties.getPrefix(), env.getProperty("spring.application.name"));
            CompositePropertySource composite = new CompositePropertySource("etcd");
            Collections.reverse(contexts);
            for (String context : contexts) {
                EtcdPropertySource propertySource = new EtcdPropertySource(context, this.etcd, this.properties);
                propertySource.init();
                composite.addPropertySource((PropertySource)propertySource);
            }
            return composite;
        }
        return null;
    }

    private void setupContext(List<String> contexts, String[] profiles, String prefix, String item) {
        String ctx = prefix + "/" + item;
        if (ctx.startsWith("/")) {
            ctx = ctx.substring(1);
        }
        contexts.add(ctx);
        for (String profile : profiles) {
            contexts.add(ctx + this.properties.getProfileSeparator() + profile);
        }
    }
}

