/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.javaagent.core;

import cn.com.duibaboot.ext.autoconfigure.javaagent.core.AbstractClassEnhancePluginDefine;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.PluginCfg;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.PluginDefine;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.PluginResourcesResolver;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginBootstrap {
    private final Logger logger = LoggerFactory.getLogger((String)PluginBootstrap.class.getName());

    public List<AbstractClassEnhancePluginDefine> loadPlugins() {
        PluginResourcesResolver resolver = new PluginResourcesResolver();
        List<URL> resources = resolver.getResources();
        if (resources == null || resources.size() == 0) {
            this.logger.info("no plugin files (agent-plugin.def) found, continue to start application.");
            return new ArrayList<AbstractClassEnhancePluginDefine>();
        }
        for (URL pluginUrl : resources) {
            try {
                PluginCfg.INSTANCE.load(pluginUrl.openStream());
            }
            catch (Throwable t) {
                this.logger.error(String.format("plugin file [%s] init failure.", pluginUrl), t);
            }
        }
        List<PluginDefine> pluginClassList = PluginCfg.INSTANCE.getPluginClassList();
        ArrayList<AbstractClassEnhancePluginDefine> plugins = new ArrayList<AbstractClassEnhancePluginDefine>();
        for (PluginDefine pluginDefine : pluginClassList) {
            try {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("loading plugin class " + pluginDefine.getDefineClass());
                }
                AbstractClassEnhancePluginDefine plugin = (AbstractClassEnhancePluginDefine)Class.forName(pluginDefine.getDefineClass()).newInstance();
                plugins.add(plugin);
            }
            catch (Throwable t) {
                this.logger.error(String.format("load plugin [%s] failure.", pluginDefine.getDefineClass()), t);
            }
        }
        return plugins;
    }
}

