package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon.loadbalancer;

import java.util.ArrayList;
import java.util.List;

import cn.com.duiba.boot.netflix.ribbon.RibbonServerListFilter;
import cn.com.duiba.boot.utils.NetUtils;
import com.netflix.loadbalancer.Server;
import com.netflix.niws.loadbalancer.DiscoveryEnabledServer;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;

/**
 * 判断如果有和当前IP一样的IP的服务（或者Ip前三个字节一样），则优先调度。
 */
@Order(-2)
public class IpAffinityServerListFilter implements RibbonServerListFilter {

    @Value("${duiba.ribbon.loadbalance.ip.affinity.enabled:false}")
    private boolean ipAffinityEnabled;

    @Override
    public List<Server> filter(List<Server> serverList, Object key) {
        if(!ipAffinityEnabled || serverList.isEmpty()){
            return serverList;
        }
        for(Server s : serverList){
            if(!(s instanceof DiscoveryEnabledServer)){
                return serverList;
            }
        }

        String localIp = NetUtils.getLocalIp();
        List<Server> filteredList = new ArrayList<>();
        for (Server server : serverList) {
            String remoteIp = ((DiscoveryEnabledServer) server).getInstanceInfo().getIPAddr();
            if (isSameIpOrPod(localIp, remoteIp)) {
                filteredList.add(server);
            }
        }

        return filteredList.isEmpty() ? serverList : filteredList;
    }

    private boolean isSameIpOrPod(String localIp, String remoteIp) {
        if (localIp.equals(remoteIp)) {
            return true;
        }

        int l1 = localIp.lastIndexOf('.');
        int l2 = remoteIp.lastIndexOf('.');
        if (l1 != -1 && l2 != -1 && l1 == l2
                && localIp.substring(0, l1).equals(remoteIp.substring(0, l2))) {
            return true;
        }

        return false;
    }
}
