package cn.com.duibaboot.ext.autoconfigure.data.redis;

import cn.com.duiba.wolf.cache.Hessian2SerializationRedisSerializer;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.actuate.endpoint.mvc.AbstractNamedMvcEndpoint;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * 棱镜后台有根据redis的key查询value的功能
 * 需要支持hessain2序列化的redis kv的查询，
 * Created by guoyanfei .
 * 2019-07-08 .
 */
@Slf4j
public class Hessian2RedisDeserializeMvcEndpoint extends AbstractNamedMvcEndpoint {

    private RedisSerializer<Object> valueRedisSerializer = new Hessian2SerializationRedisSerializer();

    public Hessian2RedisDeserializeMvcEndpoint() {
        super("hessian2RedisDeserialize", "/hessian2RedisDeserialize", true);
    }

    @ResponseBody
    @RequestMapping(method = RequestMethod.POST)
    public String invoke(@RequestBody byte[] data) {
        JSONObject redisValueJson = new JSONObject();
        try {
            Object value = valueRedisSerializer.deserialize(data);
            redisValueJson.put("redisValue", value);
            redisValueJson.put("deserializeSuccess", true);
        } catch (Exception e) {
            log.debug("Hessian2Redis反序列化异常", e);
            redisValueJson.put("message", e.getMessage());
            redisValueJson.put("deserializeSuccess", false);
        }
        return redisValueJson.toJSONString();
    }
}
