package cn.com.duibaboot.ext.autoconfigure.etcd;

import cn.com.duiba.wolf.utils.DateUtils;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;

import java.util.Date;

public class EtcdLastRefreshStateEndpoint extends AbstractEndpoint<EtcdLastRefreshStateEndpoint.EtcdLastRefreshState> {

    private static volatile EtcdLastRefreshState etcdLastRefreshState;

    public static void markSuccess() {
        etcdLastRefreshState = new EtcdLastRefreshState(DateUtils.getSecondStr(new Date()), true);
    }

    public static void markFail() {
        etcdLastRefreshState = new EtcdLastRefreshState(DateUtils.getSecondStr(new Date()), false);
    }

    public EtcdLastRefreshStateEndpoint() {
        super("etcdLastRefreshState");
    }

    @Override
    public EtcdLastRefreshState invoke() {
        return etcdLastRefreshState;
    }

    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    static class EtcdLastRefreshState {

        private String refreshDatetime;

        private Boolean refreshState;
    }

}
