package cn.com.duibaboot.ext.autoconfigure.flowreplay.record.endpoint;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.JsonResult;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.RecordContextHolder;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.sampler.PercentageBasedRecordSampler;
import org.springframework.boot.actuate.endpoint.mvc.AbstractNamedMvcEndpoint;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;

/**
 * 流量录制开始
 */
public class RecordMvcEndpoint extends AbstractNamedMvcEndpoint {

    @Resource
    private PercentageBasedRecordSampler percentageBasedRecordSampler;

    public RecordMvcEndpoint() {
        super("flow/record", "/flow/record", true);
    }

    @ResponseBody
    @RequestMapping(method = RequestMethod.POST)
    public String invoke(@RequestBody RecordConfigDto recordConfig) {
        JsonResult<String> result;
        try {
            // 开始录制
            RecordContextHolder.start(recordConfig);
            percentageBasedRecordSampler.init(recordConfig.getSamplerPercentage(), RecordContextHolder.getStartTime());
            result = JsonResult.successResult("ok");
        } catch (Exception e) {
            result = JsonResult.failedResult(e.getMessage());
        }
        return result.toJSONString();
    }

}
