package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.endpoint;

import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.actuate.endpoint.mvc.AbstractNamedMvcEndpoint;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

/**
 * 获取系统当前时间
 */
@Slf4j
public class ReplaySysTimeMvcEndpoint extends AbstractNamedMvcEndpoint {

    private static final ZoneId ZONE_ID = ZoneId.systemDefault();

    private static DateTimeFormatter YYYY_MM_DD = DateTimeFormatter.ofPattern("yyyyMMdd");

    public ReplaySysTimeMvcEndpoint() {
        super("flow/replay/systime", "/flow/replay/systime", true);
    }

    @ResponseBody
    @RequestMapping(method = RequestMethod.GET)
    public String invoke() {
        JSONObject result = new JSONObject();
        result.put("newDate", DateUtils.getSecondStr(new Date()));
        result.put("SystemCurrentTimeMillis", DateUtils.getSecondStr(System.currentTimeMillis()));
        result.put("DateTimeFormatterDay", YYYY_MM_DD.format(new Date().toInstant().atZone(ZONE_ID).toLocalDateTime()));
        return result.toJSONString();
    }

}
