package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.replayer;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.*;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceResult;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FlowReplayTrace;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.RemoteServiceFlowReplaySpan;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ReflectionUtils;

import javax.annotation.Resource;
import java.lang.reflect.Method;

/**
 * RemoteService 的回归器
 * Created by guoyanfei .
 * 2019-02-26 .
 */
public class RemoteServiceReplayer implements Replayer {

    @Resource
    private ApplicationContext applicationContext;

    @Override
    public ReplayTraceResult replay(FlowReplayTrace trace) {
        RemoteServiceFlowReplaySpan span = (RemoteServiceFlowReplaySpan) trace.getMainSpan();
        Object obj = applicationContext.getBean(toLowerCaseFirstOne(span.getTypeName()));

        // 创建回归详情trace(等同一次录制)
        FlowReplayTrace.cleanRecordEnv();
        RemoteServiceFlowReplaySpan mainSpan = RemoteServiceFlowReplaySpan.createSpan(span);
        FlowReplayTrace.createReplayTrace(mainSpan, trace.getTraceId());

        ReplayTraceContext.create(trace, FlowReplayTrace.get());
        ReplayTraceContext context = null;
        Object replayResultValue = null;
        try {
            String[] parameterTypes = span.getParameterTypes();
            int parameterLength = parameterTypes.length;
            Class[] parameterTypeClasses = null;
            if (parameterLength > 0) {
                parameterTypeClasses = new Class[parameterLength];
                for (int i = 0; i < parameterLength; i++) {
                    parameterTypeClasses[i] = Class.forName(parameterTypes[i]);
                }
            }
            Method method = ReflectionUtils.findMethod(obj.getClass(), span.getMethodName(), parameterTypeClasses);
            replayResultValue = ReflectionUtils.invokeMethod(method, obj, span.getParameterValues());
        } catch (ClassNotFoundException e) {
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_300);
        } finally {
            context = ReplayTraceContext.getAndRemove();
        }
        if (context == null) {
            throw new FlowReplayException("单个用例回归上下文丢失_traceId=" + trace.getTraceId());
        }
        if (context.isErrorMarked()) {
            return ReplayTraceResult.failResult(trace, context.getReplayDetailTrace(), context.getErrorMsgType(), context.getErrorMsgDetail(), context.getStepDiffColumns());
        }
        return ReplayTraceResult.successResult(trace, context.getReplayDetailTrace(), replayResultValue, context.getStepDiffColumns());
    }

    /**
     * 字符串首字母小写
     * @param s
     * @return
     */
    private static String toLowerCaseFirstOne(String s) {
        if (Character.isLowerCase(s.charAt(0))) {
            return s;
        } else {
            return Character.toLowerCase(s.charAt(0)) + s.substring(1);
        }
    }

}
