package cn.com.duibaboot.ext.autoconfigure.flowreplay.span;

import cn.com.duiba.wolf.utils.UUIDUtils;

import java.lang.reflect.Method;

/**
 * guava缓存类型的span
 * Created by guoyanfei .
 * 2019-04-15 .
 */
public class GuavaCacheFlowReplaySpan extends StandardSpan {

    private static final long serialVersionUID = 2104265694610835781L;

    private boolean guavaOptionalReturnValue = false;

    private boolean javaOptionalReturnValue = false;

    @Override
    public SpanType getSpanType() {
        return SpanType.GUAVA_CACHE;
    }

    /**
     * 创建span
     * @param method
     * @param allArguments
     * @param argumentsTypes
     * @param ret
     * @return
     */
    public static GuavaCacheFlowReplaySpan createSpan(Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) {
        String[] parameterTypes = null;
        Class<?>[] argumentsTypesTemp = customizeArgumentsTypes(method, argumentsTypes);
        if (argumentsTypesTemp.length > 0) {
            parameterTypes = new String[argumentsTypesTemp.length];
            for (int i = 0; i < argumentsTypesTemp.length; i++) {
                parameterTypes[i] = argumentsTypesTemp[i].getName();
            }
        }
        GuavaCacheFlowReplaySpan span = new GuavaCacheFlowReplaySpan();
        span.setSpanId(UUIDUtils.createUUID());
        span.setMethodName(method.getName());
        span.setParameterTypes(parameterTypes);
        span.setParameterValues(customizeParameterValues(method, allArguments));
        span.setRet(method, ret);
        return span;
    }

    public void setRet(Method method, Object ret) {
        this.setReturnType(method.getReturnType().getName());
        if (ret == null) {
            return;
        }
        Object retTemp = null;
        if (ret instanceof java.util.Optional) {
            java.util.Optional optional = (java.util.Optional) ret;
            if (optional.isPresent()) {
                retTemp = optional.get();
            }
            this.javaOptionalReturnValue = true;
        } else if (ret instanceof com.google.common.base.Optional) {
            com.google.common.base.Optional optional = (com.google.common.base.Optional) ret;
            if (optional.isPresent()) {
                retTemp = optional.get();
            }
            this.guavaOptionalReturnValue = true;
        } else {
            retTemp = ret;
        }
        this.setReturnValue(retTemp);
    }

    public static Class<?>[] customizeArgumentsTypes(Method method, Class<?>[] argumentsTypes) {
        if ("get".equals(method.getName())) {
            return new Class<?>[] { argumentsTypes[0] };
        }
        return argumentsTypes;
    }

    public static Object[] customizeParameterValues(Method method, Object[] parameterValues) {
        if ("get".equals(method.getName())) {
            return new Object[] { parameterValues[0] };
        }
        return parameterValues;

    }

    @Override
    public Object getReturnValue() {
        Object ret = super.getReturnValue();
        if (javaOptionalReturnValue) {
            return java.util.Optional.ofNullable(ret);
        }
        if (guavaOptionalReturnValue) {
            return com.google.common.base.Optional.fromNullable(ret);
        }
        return ret;
    }

}
