package cn.com.duibaboot.ext.autoconfigure.grouping;

import org.apache.rocketmq.common.message.Message;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.Order;

/**
 * 加入AOP，多场景测试支持rocketmq
 * ；发送rmq消息时如果当前请求是多场景测试请求，则在消息中附加场景ID.
 */
@Aspect
@Order(1)
public class RocketMqProducerServiceGroupAspect {

    @Around("execution(* org.apache.rocketmq.client.producer.DefaultMQProducer+.*(..))")
    public Object rocketMqProducerJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature) joinPoint.getSignature();
        if (signature.getMethod().getName().startsWith("send")
            && signature.getParameterTypes().length >= 1
            && signature.getParameterTypes()[0].equals(Message.class)
            && ServiceGroupContext.getCurrentGroupKey() != null){

            Object[] args = joinPoint.getArgs();
            Message m = (Message)args[0];
            if(m != null){
                //在消息中附加多场景测试的场景ID
                m.putUserProperty(ServiceGroupUtils.DUIBA_SERVICE_GROUP_KEY, ServiceGroupContext.getCurrentGroupKey());
            }
            return joinPoint.proceed(args);
        }
        return joinPoint.proceed();
    }

}
