package cn.com.duibaboot.ext.autoconfigure.perftest.jedis;

import cn.com.duiba.boot.perftest.InternalPerfTestContext;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.InstanceMethodsAroundInterceptor;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.MethodInterceptResult;

import java.lang.reflect.Method;

/**
 * 压测时不让select方法生效，因为JedisPoolMethodInterceptor内部已经select过了，这里拦截掉避免dbIndex被改回去
 */
public class JedisConnectionMethodInterceptor implements InstanceMethodsAroundInterceptor {

    @Override
    public void beforeMethod(Object objInst, Method method, Object[] allArguments,
                             Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        if (InternalPerfTestContext.isCurrentInPerfTestMode()) {
            String methodName = method.getName();
            if(methodName.equals("select")) {//压测时不让select方法生效，因为JedisPoolMethodInterceptor内部已经select过了，这里拦截掉避免改回去
                result.defineReturnValue(null);//直接设置返回值，不会再调用select方法
            }
        }
    }

    @Override
    public Object afterMethod(Object zuperCall, Object objInst, Method method, Object[] allArguments,
                              Class<?>[] argumentsTypes, Object ret) throws Throwable {
        return ret;
    }

    @Override
    public void handleMethodException(Object objInst, Method method, Object[] allArguments,
                                      Class<?>[] argumentsTypes, Throwable t) {
        //do nothing
    }
}
