package cn.com.duibaboot.ext.autoconfigure.threadpool.factory;

import cn.com.duibaboot.ext.autoconfigure.threadpool.properties.DuibaThreadPoolConfig;
import cn.com.duibaboot.ext.autoconfigure.threadpool.properties.ThreadPoolProperties;
import cn.com.duibaboot.ext.autoconfigure.threadpool.wrapper.ThreadPoolExecutorWrapper;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Map;
import java.util.Objects;

public class ThreadPoolFactoryBean implements FactoryBean<ThreadPoolExecutorWrapper> {

    @Autowired
    private DuibaThreadPoolConfig duibaThreadPoolConfig;

    private String threadPoolName;

    @Override
    public ThreadPoolExecutorWrapper getObject(){

        Objects.requireNonNull(threadPoolName);

        Map<String, ThreadPoolProperties> extra = duibaThreadPoolConfig.getExtra();

        ThreadPoolProperties properties;
        if(StringUtils.equals(threadPoolName,ThreadPoolProperties.DEFAULT_BEAN_NAME)){
            properties = duibaThreadPoolConfig.getDefaultThreadPoolProperties();
        }else{
            properties = extra.get(threadPoolName);
        }
        if(properties ==null ){
            throw new IllegalArgumentException("缺失线程池"+threadPoolName+"的配置");
        }
        return new ThreadPoolExecutorWrapper(threadPoolName,properties);
    }

    @Override
    public Class<?> getObjectType() {
        return ThreadPoolExecutorWrapper.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    public String getThreadPoolName() {
        return threadPoolName;
    }

    public void setThreadPoolName(String threadPoolName) {
        this.threadPoolName = threadPoolName;
    }

}
