package cn.com.duibaboot.ext.autoconfigure.web.cookie;

import org.apache.commons.lang.StringUtils;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

/**
 * Created by wenqi.huang on 16/8/22.
 */
public class Rfc2109CookieFixHttpServletRequestWrapper extends HttpServletRequestWrapper {
    public Rfc2109CookieFixHttpServletRequestWrapper(HttpServletRequest servletRequest) {
        super(servletRequest);
    }

    private boolean cookieFixed = false;

    @Override
    public Cookie[] getCookies() {
        Cookie[] cookies = super.getCookies();

        fixCookie(cookies);

        return cookies;
    }

    // 修复tomcat 8.5.*版本对RFC2109的cookie处理的问题。RFC2109的cookie比如：
    // $Version="1"; _ac="eyJhaWQiOjE5NTI0LCJjaWQiOjUzMzUyMjk2OX0=";$Path="/";$Domain="duiba.com.cn"
    // tomcat8.5.*版本在处理的时候会把_ac中的左右两个双引号也作为value的一部分，导致程序获取失败；tomcat8.0.*版本没有此问题。
    // 附上rfc2109的文档：https://tools.ietf.org/html/rfc2109#section-4.3.4
    private void fixCookie(Cookie[] cookies){
        if(cookieFixed){
            return;
        }

        cookieFixed = true;

        String cookieHeader = StringUtils.trimToEmpty(getHeader("Cookie"));
        if(cookieHeader.startsWith("$Version=\"1\"") || cookieHeader.startsWith("$Version=1")){//识别出是RFC2019的cookie则处理
            for(Cookie c : cookies){
                String val = c.getValue();
                if(val != null && val.startsWith("\"") && val.endsWith("\"")){
                    val = val.substring(1, val.length() - 1);
                    c.setValue(val);
                }
            }
        }
    }

}
