/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.monitor.elasticjob;

import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duibaboot.ext.autoconfigure.monitor.elasticjob.ElasticjobMonitorManager;
import cn.com.duibaboot.ext.autoconfigure.monitor.elasticjob.JobExecutionTrackEvent;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import io.elasticjob.autoconfigure.eventbus.JobEventCacheStorage;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.quartz.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.mvc.AbstractNamedMvcEndpoint;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

public class ElasticjobMonitorMvcEndpoint
extends AbstractNamedMvcEndpoint {
    private static final Logger log = LoggerFactory.getLogger(ElasticjobMonitorMvcEndpoint.class);
    @Autowired
    private ElasticjobMonitorManager elasticjobMonitorManager;

    public ElasticjobMonitorMvcEndpoint() {
        super("monitor/elasticjob", "/monitor/elasticjob", true);
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, produces={"application/vnd.spring-boot.actuator.v1+json", "application/json"}, value={"/{path}"})
    public Object invoke(@PathVariable String path, HttpServletRequest request) {
        if (path.equals("namespace")) {
            return this.elasticjobMonitorManager.getJobNamespace();
        }
        if (path.equals("trigger")) {
            String jobClassName = request.getParameter("key");
            String shardingItems = request.getParameter("shardingItems");
            if (StringUtils.isBlank((CharSequence)jobClassName) || StringUtils.isBlank((CharSequence)shardingItems)) {
                return Boolean.FALSE;
            }
            return this.elasticjobMonitorManager.trigger(jobClassName, Splitter.on((String)",").splitToList((CharSequence)shardingItems).stream().map(Integer::parseInt).collect(Collectors.toList()));
        }
        if (path.equals("consumeEvent")) {
            return this.buildTrackEvent();
        }
        return "";
    }

    private List<JobExecutionTrackEvent> buildTrackEvent() {
        boolean isPresent = ClassUtils.isPresent((String)"io.elasticjob.autoconfigure.eventbus.JobEventCacheStorage", null);
        if (!isPresent) {
            return Collections.emptyList();
        }
        List events = JobEventCacheStorage.consumeEvent();
        ArrayList trackEvents = Lists.newArrayListWithCapacity((int)events.size());
        events.forEach(event -> {
            JobExecutionTrackEvent trackEvent = (JobExecutionTrackEvent)BeanUtils.copy((Object)event, JobExecutionTrackEvent.class);
            trackEvent.setFailureCause(event.getFailureCause());
            String cron = this.elasticjobMonitorManager.getJobCron(event.getJobName());
            try {
                CronExpression cronSequenceGenerator = new CronExpression(cron);
                Date nextTime = cronSequenceGenerator.getNextValidTimeAfter(trackEvent.getStartTime());
                trackEvent.setNextTime(nextTime);
            }
            catch (ParseException e) {
                log.warn("\u89e3\u6790\u4efb\u52a1\u7684\u4e0b\u6b21\u6267\u884c\u65f6\u95f4\u5f02\u5e38", (Throwable)e);
            }
            trackEvents.add(trackEvent);
        });
        return trackEvents;
    }
}

