/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.data.hbase;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.HTableInterfaceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTableConnectionFactory
implements HTableInterfaceFactory {
    private static final Logger logger = LoggerFactory.getLogger(HTableConnectionFactory.class);
    private Connection connection;

    public HTableConnectionFactory(Configuration configuration) {
        try {
            this.connection = ConnectionFactory.createConnection((Configuration)configuration);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public HTableInterface createHTableInterface(Configuration config, byte[] tableName) {
        try {
            return (HTableInterface)this.connection.getTable(TableName.valueOf((byte[])tableName));
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void releaseHTableInterface(HTableInterface table) throws IOException {
    }

    public void destroy() {
        try {
            this.connection.close();
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
        }
    }
}

