/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.etcd.client;

import cn.com.duibaboot.ext.autoconfigure.etcd.client.EtcdKVClientDelegate;
import cn.com.duibaboot.ext.autoconfigure.etcd.exception.EtcdOperationException;
import com.coreos.jetcd.Client;
import com.coreos.jetcd.KV;
import com.coreos.jetcd.data.ByteSequence;
import com.coreos.jetcd.data.KeyValue;
import com.coreos.jetcd.kv.GetResponse;
import com.coreos.jetcd.options.DeleteOption;
import com.coreos.jetcd.options.GetOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.collections.CollectionUtils;

public class JetcdKVClientDelegate
implements EtcdKVClientDelegate {
    private static final int timeout = 5;
    private static final TimeUnit timeoutUnit = TimeUnit.SECONDS;
    private final KV kvClient;

    public JetcdKVClientDelegate(Client etcdClient) {
        this.kvClient = etcdClient.getKVClient();
    }

    @Override
    public void put(String key, String value) {
        CompletableFuture putResponseCompletableFuture = this.kvClient.put(ByteSequence.fromString((String)key), ByteSequence.fromString((String)value));
        try {
            putResponseCompletableFuture.get(5L, timeoutUnit);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new EtcdOperationException(e);
        }
    }

    @Override
    public String get(String key) {
        List<KeyValue> kvs = this.get(ByteSequence.fromString((String)key), GetOption.DEFAULT);
        if (CollectionUtils.isEmpty(kvs)) {
            return null;
        }
        return kvs.get(0).getValue().toStringUtf8();
    }

    @Override
    public Map<String, String> getWithPrefix(String prefix) {
        GetOption option = GetOption.newBuilder().withPrefix(ByteSequence.fromString((String)prefix)).build();
        List<KeyValue> kvs = this.get(ByteSequence.fromString((String)prefix), option);
        if (CollectionUtils.isEmpty(kvs)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> resultMap = new HashMap<String, String>();
        for (KeyValue kv : kvs) {
            resultMap.put(kv.getKey().toStringUtf8(), kv.getValue().toStringUtf8());
        }
        return resultMap;
    }

    private List<KeyValue> get(ByteSequence key, GetOption option) {
        GetResponse getResponse;
        CompletableFuture getResponseCompletableFuture = this.kvClient.get(key, option);
        try {
            getResponse = (GetResponse)getResponseCompletableFuture.get(5L, timeoutUnit);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new EtcdOperationException(e);
        }
        if (getResponse == null) {
            return Collections.emptyList();
        }
        return getResponse.getKvs();
    }

    @Override
    public void delete(String key) {
        this.delete(ByteSequence.fromString((String)key), DeleteOption.DEFAULT);
    }

    @Override
    public void deleteWithPrefix(String prefix) {
        DeleteOption option = DeleteOption.newBuilder().withPrefix(ByteSequence.fromString((String)prefix)).build();
        this.delete(ByteSequence.fromString((String)prefix), option);
    }

    private void delete(ByteSequence key, DeleteOption option) {
        CompletableFuture deleteResponseCompletableFuture = this.kvClient.delete(key, option);
        try {
            deleteResponseCompletableFuture.get(5L, timeoutUnit);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new EtcdOperationException(e);
        }
    }

    public static void main(String[] args) {
        JetcdKVClientDelegate delegate = new JetcdKVClientDelegate(Client.builder().endpoints(new String[]{"http://172.16.80.120:2379"}).build());
        System.out.println(delegate.getWithPrefix("/config"));
        System.out.println(delegate.get("/config/zuul-server/zuul/routes/millionaire-web222/strip-prefix"));
    }
}

