/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.record;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayException;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.RecordDetailContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.RecordResult;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.endpoint.RecordConfigDto;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FlowReplayTrace;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RecordContext {
    private static final Logger log = LoggerFactory.getLogger(RecordContext.class);
    private static final int TRACE_QUEUE_SIZE = 500;
    private final Long usecaseSetId;
    private final Integer maxMinutes;
    private volatile Long startTime;
    private volatile Long endTime;
    private final Integer maxFileSize;
    private volatile long currentFileSize;
    private LinkedBlockingQueue<FlowReplayTrace> traceQueue = new LinkedBlockingQueue(500);
    private volatile boolean recordFinished = false;
    private volatile RecordResult recordResult;
    private final RecordDetailContext recordDetailContext;

    public RecordContext(RecordConfigDto recordConfig) {
        if (recordConfig == null || !recordConfig.isLegal()) {
            throw new FlowReplayException("\u5f55\u5236\u914d\u7f6e\u4e3a\u7a7aor\u5f55\u5236\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        this.usecaseSetId = recordConfig.getUsecaseSetId();
        this.maxMinutes = recordConfig.getMaxMinutes();
        this.startTime = null;
        this.endTime = null;
        this.maxFileSize = recordConfig.getMaxFileSize();
        this.currentFileSize = 0L;
        this.recordResult = null;
        this.recordDetailContext = new RecordDetailContext(recordConfig.getStackFramesPrefixWhitelist());
    }

    public RecordDetailContext getRecordDetailContext() {
        return this.recordDetailContext;
    }

    public boolean isTimeToEnd() {
        if (this.startTime == null || this.maxMinutes == null) {
            log.error("\u5f55\u5236\u5f00\u59cb\u65f6\u95f4\u4e3a\u7a7aor\u6700\u5927\u5f55\u5236\u5206\u949f\u6570\u4e3a\u7a7a_\u8fd4\u56de\u9700\u8981\u7ed3\u675f\u5f55\u5236");
            return true;
        }
        long expectEndTime = this.startTime + (long)(this.maxMinutes * 60 * 1000);
        return expectEndTime < System.currentTimeMillis();
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
    }

    public void end() {
        this.endTime = System.currentTimeMillis();
    }

    public void setRecordResult(RecordResult recordResult) {
        this.recordResult = recordResult;
    }

    public Long getUsecaseSetId() {
        return this.usecaseSetId;
    }

    public Integer getMaxFileSize() {
        return this.maxFileSize;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public long getCurrentFileSize() {
        return this.currentFileSize;
    }

    public RecordResult getRecordResult() {
        return this.recordResult;
    }

    public void setCurrentFileSize(long currentFileSize) {
        this.currentFileSize = currentFileSize;
    }

    public void offerTrace(FlowReplayTrace trace) {
        this.traceQueue.offer(trace);
    }

    public FlowReplayTrace pollTrace() throws InterruptedException {
        return this.traceQueue.poll(2L, TimeUnit.SECONDS);
    }

    public boolean isTraceQueueEmpty() {
        return this.traceQueue.size() < 1;
    }

    public void recordFinished() {
        this.recordFinished = true;
    }

    public boolean isRecordFinished() {
        return this.recordFinished;
    }
}

