/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.span;

import cn.com.duiba.wolf.utils.UUIDUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.SpanType;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.StandardSpan;
import java.lang.reflect.Method;

public class FeignClientFlowReplaySpan
extends StandardSpan {
    private static final long serialVersionUID = 6228393678957825891L;
    private String apiName;
    private String typeName;
    private String typeFullPath;

    @Override
    public SpanType getSpanType() {
        return SpanType.FEIGN_CLIENT;
    }

    public static FeignClientFlowReplaySpan createSpan(Method method, Object[] args, Object ret) {
        Class<?>[] parameterTypeClasses = method.getParameterTypes();
        String[] parameterTypes = null;
        if (parameterTypeClasses.length > 0) {
            parameterTypes = new String[parameterTypeClasses.length];
            for (int i = 0; i < parameterTypeClasses.length; ++i) {
                parameterTypes[i] = parameterTypeClasses[i].getName();
            }
        }
        Class<?> returnTypeClass = method.getReturnType();
        FeignClientFlowReplaySpan span = new FeignClientFlowReplaySpan();
        span.setSpanId(UUIDUtils.createUUID());
        span.setMethodName(method.getName());
        span.setParameterTypes(parameterTypes);
        span.setParameterValues(args);
        span.setReturnType(returnTypeClass != null ? returnTypeClass.getName() : null);
        span.setReturnValue(ret);
        span.apiName = FlowReplayUtils.parseApiNameByMethod(method);
        span.typeName = method.getDeclaringClass().getSimpleName();
        span.typeFullPath = method.getDeclaringClass().getName();
        return span;
    }

    public String getApiName() {
        return this.apiName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getTypeFullPath() {
        return this.typeFullPath;
    }
}

