/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.security.dpefensivepolicy;

import cn.com.duibaboot.ext.autoconfigure.core.utils.HttpRequestUtils;
import cn.com.duibaboot.ext.autoconfigure.security.DefensivePolicy;
import cn.com.duibaboot.ext.autoconfigure.security.exception.DuibaSecurityException;
import cn.com.duibaboot.ext.autoconfigure.web.wrapper.XssHttpServletRequestWrapper;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.MediaType;

public class XssDefensivePolicy
implements DefensivePolicy {
    @Override
    public Set<MediaType> getMediaTypes() {
        return Sets.newHashSet((Object[])new MediaType[]{MediaType.ALL});
    }

    @Override
    public HttpServletRequest preprocessorRequest(HttpServletRequest request) {
        if (this.isFeignRequest(request)) {
            return request;
        }
        return new XssHttpServletRequestWrapper(request);
    }

    @Override
    public void doDefensive(HttpServletRequest request, HttpServletResponse response) throws DuibaSecurityException {
    }

    protected boolean isFeignRequest(HttpServletRequest request) {
        if (!"true".equals(request.getHeader("X-Rpc"))) {
            return false;
        }
        return HttpRequestUtils.isLanRequest(request);
    }
}

