/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.nustaq.serialization;

import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import shaded.org.nustaq.serialization.FSTClazzInfo;
import shaded.org.nustaq.serialization.FSTConfiguration;
import shaded.org.nustaq.serialization.FSTDecoder;
import shaded.org.nustaq.serialization.FSTEncoder;
import shaded.org.nustaq.serialization.util.FSTIdentity2IdMap;
import shaded.org.nustaq.serialization.util.FSTObject2IntMap;

public class FSTClazzNameRegistry {
    public static final int LOWEST_CLZ_ID = 3;
    public static final int FIRST_USER_CLZ_ID = 1000;
    FSTIdentity2IdMap clzToId;
    FSTClazzInfo[] idToClz;
    FSTClazzNameRegistry parent;
    int classIdCount = 3;
    HashMap<String, Class> classCache = new HashMap(200);
    AtomicBoolean classCacheLock = new AtomicBoolean(false);

    public FSTClazzNameRegistry(FSTClazzNameRegistry par) {
        this.parent = par;
        if (this.parent != null) {
            this.classIdCount = Math.max(1000, this.parent.classIdCount + 1);
            this.clzToId = new FSTIdentity2IdMap(13);
            this.idToClz = new FSTClazzInfo[31];
        } else {
            this.clzToId = new FSTIdentity2IdMap(FSTObject2IntMap.adjustSize(400));
            this.idToClz = new FSTClazzInfo[200];
        }
    }

    public void clear() {
        if (this.clzToId.size() > 0) {
            this.clzToId.clear();
        }
        this.classIdCount = 3;
        if (this.parent != null) {
            this.classIdCount = Math.max(1000, this.parent.classIdCount + 1);
        }
    }

    public void registerClass(Class c, FSTConfiguration conf) {
        if (this.getIdFromClazz(c) != Integer.MIN_VALUE) {
            return;
        }
        this.registerClassNoLookup(c, null, conf);
    }

    private void registerClassNoLookup(Class c, FSTClazzInfo cli, FSTConfiguration conf) {
        this.addClassMapping(c, this.classIdCount++, cli, conf);
    }

    public void registerClass(Class c, int code, FSTConfiguration conf) {
        if (this.getIdFromClazz(c) != Integer.MIN_VALUE) {
            return;
        }
        this.addClassMapping(c, code, null, conf);
    }

    protected void addClassMapping(Class c, int id, FSTClazzInfo clInfo, FSTConfiguration conf) {
        this.clzToId.put(c, id);
        if (clInfo == null) {
            clInfo = conf.getCLInfoRegistry().getCLInfo(c, conf);
        }
        if (this.idToClz.length <= id) {
            FSTClazzInfo[] tmp = new FSTClazzInfo[id + 100];
            System.arraycopy(this.idToClz, 0, tmp, 0, this.idToClz.length);
            this.idToClz = tmp;
        }
        this.idToClz[id] = clInfo;
        if (this.parent == null) {
            clInfo.setClzId(id);
        }
    }

    public int getIdFromClazz(Class c) {
        int res = Integer.MIN_VALUE;
        if (this.parent != null) {
            res = this.parent.getIdFromClazz(c);
        }
        if (res == Integer.MIN_VALUE) {
            res = this.clzToId.get(c);
        }
        return res;
    }

    public void encodeClass(FSTEncoder out, FSTClazzInfo ci) throws IOException {
        int clzId = ci.getClzId();
        if (clzId >= 0) {
            out.writeFShort((short)clzId);
        } else if (ci.isAsciiNameShortString) {
            Class aClass = ci.getClazz();
            int clid = this.getIdFromClazz(aClass);
            if (clid != Integer.MIN_VALUE) {
                out.writeFShort((short)clid);
            } else {
                byte[] bufferedName = ci.getBufferedName();
                out.writeFShort((short)1);
                out.writeFInt((char)bufferedName.length);
                out.writeRawBytes(bufferedName, 0, bufferedName.length);
                this.registerClassNoLookup(aClass, ci, ci.conf);
            }
        } else {
            this.encodeClass(out, ci.getClazz());
        }
    }

    public void encodeClass(FSTEncoder out, Class c) throws IOException {
        int clid = this.getIdFromClazz(c);
        if (clid != Integer.MIN_VALUE) {
            out.writeFShort((short)clid);
        } else {
            this.encodeClassName(out, c, out.getConf());
        }
    }

    private void encodeClassName(FSTEncoder out, Class c, FSTConfiguration conf) throws IOException {
        out.writeFShort((short)0);
        out.writeStringUTF(c.getName());
        this.registerClassNoLookup(c, null, conf);
    }

    public FSTClazzInfo decodeClass(FSTDecoder in, FSTConfiguration conf) throws IOException, ClassNotFoundException {
        short c = in.readFShort();
        if (c < 3) {
            String clName = c == 0 ? in.readStringUTF() : in.readStringAsc();
            Class cl = this.classForName(clName, conf);
            FSTClazzInfo clInfo = conf.getCLInfoRegistry().getCLInfo(cl, conf);
            this.registerClassNoLookup(cl, clInfo, conf);
            return clInfo;
        }
        FSTClazzInfo aClass = this.getClazzFromId(c);
        if (aClass == null) {
            throw new RuntimeException("unable to find class for code " + c);
        }
        return aClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Class classForName(String clName, FSTConfiguration conf) throws ClassNotFoundException {
        if (this.parent != null) {
            return this.parent.classForName(clName, conf);
        }
        while (!this.classCacheLock.compareAndSet(false, true)) {
        }
        Class res = this.classCache.get(clName);
        if (res != null) return res;
        try {
            res = Class.forName(clName, false, conf.getClassLoader());
        }
        finally {
            if (res == null) return res;
        }
        this.classCache.put(clName, res);
        return res;
        finally {
            this.classCacheLock.set(false);
        }
    }

    public void registerClazzFromOtherLoader(Class cl) {
        while (!this.classCacheLock.compareAndSet(false, true)) {
        }
        this.classCache.put(cl.getName(), cl);
        this.classCacheLock.set(false);
    }

    public FSTClazzInfo getClazzFromId(int c) {
        FSTClazzInfo res = null;
        if (this.parent != null) {
            res = this.parent.getClazzFromId(c);
        }
        if (res == null) {
            if (c < 0 || c >= this.idToClz.length) {
                return null;
            }
            return this.idToClz[c];
        }
        return res;
    }
}

