/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cat;

import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class CatRediscachePlugin {
    @Around(value="execution(* cn.com.duiba.wolf.redis.RedisClient.*(..))")
    public Object redisJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String methodName = signature.getMethod().getName();
        if (CatUtils.isCatEnabled()) {
            Transaction transaction = "get".equals(methodName) ? Cat.newTransaction((String)"Cache.redis", (String)(methodName + ":" + methodName)) : Cat.newTransaction((String)"Cache.redis", (String)methodName);
            try {
                Object cacheValue = joinPoint.proceed();
                if ("get".equals(methodName) && cacheValue == null) {
                    Cat.logEvent((String)"Cache.redis", (String)(methodName + ":missed"));
                }
                transaction.setStatus("0");
                Object object = cacheValue;
                return object;
            }
            catch (Throwable e) {
                Cat.logError((Throwable)e);
                transaction.setStatus(e);
                throw e;
            }
            finally {
                transaction.complete();
            }
        }
        return joinPoint.proceed();
    }
}

