/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon.loadbalancer;

import cn.com.duiba.boot.netflix.ribbon.RibbonServerListFilter;
import cn.com.duiba.boot.utils.NetUtils;
import com.netflix.loadbalancer.Server;
import com.netflix.niws.loadbalancer.DiscoveryEnabledServer;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;

@Order(value=-2)
public class IpAffinityServerListFilter
implements RibbonServerListFilter {
    @Value(value="${duiba.ribbon.loadbalance.ip.affinity.enabled:false}")
    private boolean ipAffinityEnabled;

    public List<Server> filter(List<Server> serverList, Object key) {
        if (!this.ipAffinityEnabled || serverList.isEmpty()) {
            return serverList;
        }
        for (Server s : serverList) {
            if (s instanceof DiscoveryEnabledServer) continue;
            return serverList;
        }
        String localIp = NetUtils.getLocalIp();
        ArrayList<Server> filteredList = new ArrayList<Server>();
        for (Server server : serverList) {
            String remoteIp = ((DiscoveryEnabledServer)server).getInstanceInfo().getIPAddr();
            if (!this.isSameIpOrPod(localIp, remoteIp)) continue;
            filteredList.add(server);
        }
        return filteredList.isEmpty() ? serverList : filteredList;
    }

    private boolean isSameIpOrPod(String localIp, String remoteIp) {
        if (localIp.equals(remoteIp)) {
            return true;
        }
        int l1 = localIp.lastIndexOf(46);
        int l2 = remoteIp.lastIndexOf(46);
        return l1 != -1 && l2 != -1 && l1 == l2 && localIp.substring(0, l1).equals(remoteIp.substring(0, l2));
    }
}

