/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.devtools;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.springframework.boot.devtools.classpath.ClassPathChangedEvent;
import org.springframework.boot.devtools.filewatch.ChangedFiles;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.EventListener;

public class ClassPathChangedFilesContainer {
    private ApplicationContext applicationContext;
    private Set<ChangedFiles> changedFilesSet = Sets.newHashSet();

    public ClassPathChangedFilesContainer(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventListener
    public void onClassPathChanged(ClassPathChangedEvent event) {
        if (!event.isRestartRequired()) {
            Set set = event.getChangeSet();
            Set<ChangedFiles> set2 = this.changedFilesSet;
            synchronized (set2) {
                this.changedFilesSet.addAll(set);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ChangedFiles> getChangedFilesAndClear() {
        HashSet set;
        Set<ChangedFiles> set2 = this.changedFilesSet;
        synchronized (set2) {
            set = Sets.newHashSet(this.changedFilesSet);
            this.changedFilesSet.clear();
        }
        return set;
    }

    public void requestRestart(Set<?> changedFilesSet) {
        this.applicationContext.publishEvent((ApplicationEvent)new ClassPathChangedEvent((Object)this.applicationContext, changedFilesSet, true));
    }
}

