/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.httpclient.ssre;

import cn.com.duiba.boot.utils.NetUtils;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.SsreHttpClientWrapper;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.SsreRiskException;
import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SsreUtils {
    private static Logger logger = LoggerFactory.getLogger(SsreHttpClientWrapper.class);

    SsreUtils() {
    }

    static void checkSsre(HttpHost target) {
        if (target == null) {
            return;
        }
        ArrayList addreses = Collections.emptyList();
        try {
            addreses = Lists.newArrayList((Object[])InetAddress.getAllByName(target.getHostName()));
        }
        catch (Exception e) {
            logger.debug("\u57df\u540d\u89e3\u6790\u5931\u8d25", (Throwable)e);
        }
        for (InetAddress address : addreses) {
            SsreUtils.checkSsre(address.getHostAddress());
        }
    }

    static void checkSsre(URI uri) {
        if (uri == null) {
            return;
        }
        ArrayList addreses = Collections.emptyList();
        try {
            addreses = Lists.newArrayList((Object[])InetAddress.getAllByName(uri.getHost()));
        }
        catch (Exception e) {
            logger.debug("\u57df\u540d\u89e3\u6790\u5931\u8d25", (Throwable)e);
        }
        for (InetAddress address : addreses) {
            SsreUtils.checkSsre(address.getHostAddress());
        }
    }

    static void checkSsre(String ip) {
        if (StringUtils.isBlank((CharSequence)ip)) {
            return;
        }
        if (ip.equals("127.0.0.1") || ip.equals("0:0:0:0") || NetUtils.isLanIp((String)ip)) {
            throw new SsreRiskException("SSRE\u98ce\u9669\uff0cHttpClient\u4e0d\u80fd\u7528\u4e8e\u8bbf\u95ee\u5185\u7f51");
        }
    }
}

